/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageParameter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;

public class PackageConfig
extends AbstractDescribableImpl<PackageConfig>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final boolean runTest;
    private final boolean runTraceAnalysis;
    private final List<PackageParameter> parameters;

    @DataBoundConstructor
    public PackageConfig(boolean runTest, boolean runTraceAnalysis, List<PackageParameter> parameters) {
        this.runTest = runTest;
        this.runTraceAnalysis = runTraceAnalysis;
        this.parameters = parameters == null ? new ArrayList() : PackageConfig.removeEmptyParameters(parameters);
    }

    public PackageConfig(boolean runTest, boolean runTraceAnalysis) {
        this.runTest = runTest;
        this.runTraceAnalysis = runTraceAnalysis;
        this.parameters = new ArrayList<PackageParameter>();
    }

    public boolean isRunTest() {
        return this.runTest;
    }

    public boolean isRunTraceAnalysis() {
        return this.runTraceAnalysis;
    }

    public List<PackageParameter> getParameters() {
        return this.parameters;
    }

    private static List<PackageParameter> removeEmptyParameters(List<PackageParameter> parameters) {
        ArrayList<PackageParameter> validParameters = new ArrayList<PackageParameter>();
        for (PackageParameter parameter : parameters) {
            if (!StringUtils.isNotBlank((String)parameter.getName())) continue;
            validParameters.add(parameter);
        }
        return validParameters;
    }

    @Override
    public PackageConfig expand(EnvVars envVars) {
        ArrayList<PackageParameter> parameters = new ArrayList<PackageParameter>();
        for (PackageParameter param : this.getParameters()) {
            parameters.add(param.expand(envVars));
        }
        return new PackageConfig(this.isRunTest(), this.isRunTraceAnalysis(), parameters);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof PackageConfig) {
            PackageConfig that = (PackageConfig)other;
            result = (this.parameters == null ? that.parameters == null : this.parameters.equals(that.parameters)) && this.runTest == that.runTest && this.runTraceAnalysis == that.runTraceAnalysis;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.runTest).append(this.runTraceAnalysis).append(this.parameters).toHashCode();
    }

    public static PackageConfig newInstance() {
        return new PackageConfig(true, true, null);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PackageConfig> {
        public String getDisplayName() {
            return "Package Configuration";
        }
    }
}

