/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportProjectArchiveConfig
extends ImportConfig {
    private static final long serialVersionUID = 1L;
    private final String importConfigPath;
    private final boolean replaceFiles;

    @DataBoundConstructor
    public ImportProjectArchiveConfig(String tmsPath, String importPath, String importConfigPath, boolean replaceFiles) {
        super(tmsPath, importPath, null, null);
        this.importConfigPath = StringUtils.trimToEmpty((String)importConfigPath);
        this.replaceFiles = replaceFiles;
    }

    public String getImportConfigPath() {
        return this.importConfigPath;
    }

    public boolean isReplaceFiles() {
        return this.replaceFiles;
    }

    @Override
    public ImportProjectArchiveConfig expand(EnvVars envVars) {
        String expProjectPath = envVars.expand(this.getTmsPath());
        String expImportPath = envVars.expand(this.getImportPath());
        String expImportConfigPath = envVars.expand(this.getImportConfigPath());
        return new ImportProjectArchiveConfig(expProjectPath, expImportPath, expImportConfigPath, this.isReplaceFiles());
    }

    @Override
    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ImportProjectArchiveConfig) {
            ImportProjectArchiveConfig that = (ImportProjectArchiveConfig)other;
            result = that.canEqual(this) && super.equals(that) && (this.importConfigPath == null ? that.importConfigPath == null : this.importConfigPath.equals(that.importConfigPath)) && this.replaceFiles == that.replaceFiles;
        }
        return result;
    }

    @Override
    public final boolean canEqual(Object other) {
        return other instanceof ImportProjectArchiveConfig;
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append(super.hashCode()).append((Object)this.importConfigPath).append(this.replaceFiles).toHashCode();
    }

    @Extension(ordinal=4.0)
    public static class DescriptorImpl
    extends ImportConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckTmsPath(@QueryParameter String value) {
            return this.tmsValidator.validateArchivePath(value);
        }

        public FormValidation doCheckImportConfigPath(@QueryParameter String value) {
            return this.tmsValidator.validateImportConfigPath(value);
        }

        public String getDisplayName() {
            return Messages.ImportProjectArchiveConfig_DisplayName();
        }
    }
}

