/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ExportProjectAttributeConfig
extends ExportAttributeConfig {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ExportProjectAttributeConfig(String filePath, String credentialsId, String timeout) {
        super(filePath, credentialsId, timeout);
    }

    @Override
    public ExportProjectAttributeConfig expand(EnvVars envVars) {
        String expFilePath = envVars.expand(this.getFilePath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ExportProjectAttributeConfig(expFilePath, expCredentialsId, expTimeout);
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends ExportConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return this.tmsValidator.validateProjectFile(value);
        }

        public String getDisplayName() {
            return Messages.ExportProjectAttributeConfig_DisplayName();
        }
    }
}

