/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.QueryParameter;

public abstract class ExportConfig
extends TMSConfig {
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String exportPath;
    private final boolean createNewPath;

    public ExportConfig(String filePath, String exportPath, boolean createNewPath, String credentialsId, String timeout) {
        super(credentialsId, timeout);
        this.filePath = StringUtils.trimToEmpty((String)filePath);
        this.exportPath = StringUtils.trimToEmpty((String)exportPath);
        this.createNewPath = createNewPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public boolean isCreateNewPath() {
        return this.createNewPath;
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ExportConfig) {
            ExportConfig that = (ExportConfig)other;
            String filePath = this.getFilePath();
            String exportPath = this.getExportPath();
            String thatFilePath = that.getFilePath();
            String thatExportPath = that.getExportPath();
            result = (filePath == null ? thatFilePath == null : filePath.equals(thatFilePath)) && (exportPath == null ? thatExportPath == null : exportPath.equals(thatExportPath)) && this.createNewPath == that.isCreateNewPath() && (this.getCredentialsId() == null ? that.getCredentialsId() == null : this.getCredentialsId().equals(that.getCredentialsId())) && (this.getTimeout() == null ? that.getTimeout() == null : this.getTimeout().equals(that.getTimeout()));
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.getFilePath()).append((Object)this.getExportPath()).append(this.isCreateNewPath()).append((Object)this.getCredentialsId()).append((Object)this.getTimeout()).toHashCode();
    }

    public static abstract class DescriptorImpl
    extends TMSConfig.DescriptorImpl {
        public abstract FormValidation doCheckFilePath(@QueryParameter String var1);

        public FormValidation doCheckExportPath(@QueryParameter String value) {
            return this.tmsValidator.validateExportPath(value);
        }
    }
}

