/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Project;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestExecutionInfo;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FilenameUtils;

public class ProjectClient
extends AbstractTestClient {
    private final ProjectConfig projectConfig;

    public ProjectClient(String testFile, TestConfig testConfig, ProjectConfig projectConfig, ExecutionConfig executionConfig) {
        super(testFile, testConfig, executionConfig);
        this.projectConfig = projectConfig;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @Override
    public boolean runTestCase(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        if (!this.getTestConfig().isKeepConfig() && !((Boolean)launcher.getChannel().call((Callable)new AbstractTestClient.LoadConfigCallable(this.getTestConfig(), listener))).booleanValue()) {
            return false;
        }
        if (!((Boolean)launcher.getChannel().call((Callable)new OpenProjectCallable(this.getTestFile(), this.getProjectConfig(), this.getExecutionConfig().isCheckTestFile(), listener))).booleanValue()) {
            return false;
        }
        this.setTestDescription("");
        this.setTestName(FilenameUtils.getBaseName((String)new File(this.getTestFile()).getName()));
        try {
            AbstractTestClient.TestInfoHolder testInfo = (AbstractTestClient.TestInfoHolder)launcher.getChannel().call((Callable)new RunProjectCallable(this.getTestFile(), this.getProjectConfig(), this.getExecutionConfig(), listener));
            if (testInfo == null) {
                return false;
            }
            this.setTestResult(testInfo.getTestResult());
            this.setTestReportDir(testInfo.getTestReportDir());
            this.setAborted(testInfo.isAborted());
        }
        catch (InterruptedException e) {
            logger.logError("Test execution has been interrupted!");
            return false;
        }
        return (Boolean)launcher.getChannel().call((Callable)new CloseProjectCallable(this.getTestFile(), listener)) != false;
    }

    private static final class CloseProjectCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String projectFile;
        private final TaskListener listener;

        CloseProjectCallable(String projectFile, TaskListener listener) {
            this.projectFile = projectFile;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isClosed = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Closing project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                if (comClient.closeProject(this.projectFile)) {
                    isClosed = true;
                    logger.logInfo("-> Project closed successfully.");
                } else {
                    logger.logError("-> Closing project failed!");
                }
            }
            catch (ETComException e) {
                logger.logComException(e.getMessage());
            }
            return isClosed;
        }
    }

    private static final class RunProjectCallable
    extends MasterToSlaveCallable<AbstractTestClient.TestInfoHolder, InterruptedException> {
        private static final long serialVersionUID = 1L;
        private final String projectFile;
        private final ProjectConfig projectConfig;
        private final ExecutionConfig executionConfig;
        private final TaskListener listener;

        RunProjectCallable(String projectFile, ProjectConfig projectConfig, ExecutionConfig executionConfig, TaskListener listener) {
            this.projectFile = projectFile;
            this.projectConfig = projectConfig;
            this.executionConfig = executionConfig;
            this.listener = listener;
        }

        public AbstractTestClient.TestInfoHolder call() throws InterruptedException {
            int jobExecutionMode = this.projectConfig.getJobExecMode().getValue();
            int timeout = this.executionConfig.getParsedTimeout();
            AbstractTestClient.TestInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Running project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.executeProject(this.projectFile, true, jobExecutionMode);){
                boolean isAborted = false;
                int tickCounter = 0;
                long endTimeMillis = System.currentTimeMillis() + Long.valueOf(timeout) * 1000L;
                while ("RUNNING".equals(execInfo.getState())) {
                    if (tickCounter % 60 == 0) {
                        logger.logInfo("-- tick...");
                    }
                    if (timeout > 0 && System.currentTimeMillis() > endTimeMillis) {
                        logger.logWarn(String.format("-> Test execution timeout of %d seconds reached! Aborting project now...", timeout));
                        isAborted = true;
                        execInfo.abort();
                        break;
                    }
                    Thread.sleep(1000L);
                    ++tickCounter;
                }
                testInfo = this.getTestInfo(execInfo, isAborted, logger);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException(e.getMessage());
            }
            catch (InterruptedException e) {
                testInfo = this.abortTestExecution(timeout, progId, logger);
            }
            return testInfo;
        }

        private AbstractTestClient.TestInfoHolder abortTestExecution(int timeout, String progId, TTConsoleLogger logger) {
            AbstractTestClient.TestInfoHolder testInfo = null;
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.getTestExecutionInfo();){
                logger.logWarn(String.format("-> Build interrupted! Aborting test exection...", new Object[0]));
                execInfo.abort();
                testInfo = this.getTestInfo(execInfo, true, logger);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException exc) {
                logger.logError("Caught ComException: " + exc.getMessage());
            }
            return testInfo;
        }

        private AbstractTestClient.TestInfoHolder getTestInfo(TestExecutionInfo execInfo, boolean isAborted, TTConsoleLogger logger) throws ETComException {
            String testResult = execInfo.getResult();
            logger.logInfo(String.format("-> Project execution completed with result: %s", testResult));
            String testReportDir = new File(execInfo.getReportDb()).getParentFile().getAbsolutePath();
            logger.logInfo(String.format("-> Test report directory: %s", testReportDir));
            return new AbstractTestClient.TestInfoHolder(testResult, testReportDir, isAborted);
        }

        private void postExecution(int timeout, ETComClient comClient, TTConsoleLogger logger) throws ETComException {
            if (!comClient.waitForIdle(timeout)) {
                logger.logWarn(String.format("-> Post-execution timeout of %d seconds reached!", timeout));
            }
        }
    }

    private static final class OpenProjectCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String projectFile;
        private final ProjectConfig projectConfig;
        private final boolean checkTestFile;
        private final TaskListener listener;

        OpenProjectCallable(String projectFile, ProjectConfig projectConfig, boolean checkTestFile, TaskListener listener) {
            this.projectFile = projectFile;
            this.projectConfig = projectConfig;
            this.checkTestFile = checkTestFile;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean execInCurrentPkgDir = this.projectConfig.isExecInCurrentPkgDir();
            String filterExpression = this.projectConfig.getFilterExpression();
            boolean isOpened = true;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Opening project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 Project project = (Project)comClient.openProject(this.projectFile, execInCurrentPkgDir, filterExpression);){
                logger.logInfo("-> Project opened successfully.");
                if (this.checkTestFile) {
                    logger.logInfo("- Checking project...");
                    List<AbstractTestClient.CheckInfoHolder> checks = project.check();
                    for (AbstractTestClient.CheckInfoHolder check : checks) {
                        String logMessage = String.format("%s (line %s): %s", check.getFilePath(), check.getLineNumber(), check.getErrorMessage());
                        AbstractTestClient.CheckInfoHolder.Seriousness seriousness = check.getSeriousness();
                        switch (seriousness) {
                            case NOTE: {
                                logger.logInfo(logMessage);
                                break;
                            }
                            case WARNING: {
                                logger.logWarn(logMessage);
                                break;
                            }
                            case ERROR: {
                                logger.logError(logMessage);
                                isOpened = false;
                                break;
                            }
                        }
                    }
                    if (checks.isEmpty()) {
                        logger.logInfo("-> Project validated successfully!");
                    }
                }
            }
            catch (ETComException e) {
                isOpened = false;
                logger.logError("-> Opening project failed!");
                logger.logComException(e.getMessage());
            }
            return isOpened;
        }
    }
}

