/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectArchiveConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class ImportProjectClient
extends AbstractTMSClient {
    private static final ETPlugin.ToolVersion ET_MIN_VERSION = new ETPlugin.ToolVersion(6, 5, 0, 0L);
    private static final ETPlugin.ToolVersion ET_MIN_ATTR_VERSION = new ETPlugin.ToolVersion(6, 6, 0, 0L);
    private final TMSConfig importConfig;

    public ImportProjectClient(TMSConfig importConfig) {
        this.importConfig = importConfig;
    }

    public TMSConfig getImportConfig() {
        return this.importConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importProject(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isImported = false;
        if (this.importConfig instanceof ImportProjectArchiveConfig) {
            isImported = this.importProjectArchive(launcher, listener);
        } else if (this.importConfig instanceof ImportProjectConfig && this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = ((ImportProjectConfig)this.importConfig).getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isImported = this.importConfig instanceof ImportProjectDirConfig ? this.importProjectDirFromTMS(launcher, listener) : this.importProjectFromTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isImported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importProjectAttributes(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isImported = false;
        if (this.isCompatible(ET_MIN_ATTR_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = ((ImportProjectAttributeConfig)this.importConfig).getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isImported = this.importProjectAttributesFromTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isImported;
    }

    public boolean importProjectArchive(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportProjectArchiveCallable((ImportProjectArchiveConfig)this.importConfig, listener));
    }

    private boolean importProjectFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportProjectTMSCallable((ImportProjectConfig)this.importConfig, listener));
    }

    private boolean importProjectDirFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportProjectDirTMSCallable((ImportProjectDirConfig)this.importConfig, listener));
    }

    private boolean importProjectAttributesFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportProjectAttributeCallable((ImportProjectAttributeConfig)this.importConfig, listener));
    }

    private static final class ImportProjectAttributeCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportProjectAttributeConfig importConfig;
        private final TaskListener listener;

        ImportProjectAttributeCallable(ImportProjectAttributeConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing attributes of project %s from test management system...", this.importConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importProjectAttributes(this.importConfig.getFilePath(), this.importConfig.getParsedTimeout());
                logger.logInfo("-> Project attributes imported successfully.");
            }
            catch (ETComException e) {
                logger.logError("-> Importing project attributes failed: " + e.getMessage());
            }
            return isImported;
        }
    }

    private static final class ImportProjectDirTMSCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportProjectDirConfig importConfig;
        private final TaskListener listener;

        ImportProjectDirTMSCallable(ImportProjectDirConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing project directory %s from test management system...", this.importConfig.getTmsPath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importProjectDirectory(this.importConfig.getTmsPath(), this.importConfig.getImportPath(), this.importConfig.getParsedTimeout());
                logger.logInfo(String.format("-> Project directory imported successfully to target directory %s.", this.importConfig.getImportPath()));
            }
            catch (ETComException e) {
                logger.logError("-> Importing project directory failed: " + e.getMessage());
            }
            return isImported;
        }
    }

    private static final class ImportProjectTMSCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportProjectConfig importConfig;
        private final TaskListener listener;

        ImportProjectTMSCallable(ImportProjectConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing project %s from test management system...", this.importConfig.getTmsPath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importProject(this.importConfig.getTmsPath(), this.importConfig.getImportPath(), this.importConfig.isImportMissingPackages(), this.importConfig.getParsedTimeout());
                if (isImported) {
                    logger.logInfo(String.format("-> Project imported successfully to target directory %s.", this.importConfig.getImportPath()));
                }
            }
            catch (ETComException e) {
                logger.logError("-> Importing project failed: " + e.getMessage());
            }
            return isImported;
        }
    }

    private static final class ImportProjectArchiveCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportProjectArchiveConfig importConfig;
        private final TaskListener listener;

        ImportProjectArchiveCallable(ImportProjectArchiveConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing project from archive %s...", this.importConfig.getTmsPath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                isImported = comClient.importProject(this.importConfig.getTmsPath(), this.importConfig.getImportPath(), this.importConfig.getImportConfigPath(), this.importConfig.isReplaceFiles());
                if (isImported) {
                    logger.logInfo(String.format("-> Project imported successfully to target directory %s.", this.importConfig.getImportPath()));
                }
            }
            catch (ETComException e) {
                logger.logError("-> Importing project failed: " + e.getMessage());
            }
            return isImported;
        }
    }
}

