/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class ExportPackageClient
extends AbstractTMSClient {
    private static final ETPlugin.ToolVersion ET_MIN_VERSION = new ETPlugin.ToolVersion(6, 6, 0, 0L);
    private final TMSConfig exportConfig;

    public ExportPackageClient(TMSConfig exportConfig) {
        this.exportConfig = exportConfig;
    }

    public TMSConfig getExportConfig() {
        return this.exportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportPackage(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isExported = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = ((ExportPackageConfig)this.exportConfig).getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isExported = this.exportPackageToTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isExported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportPackageAttributes(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isExported = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = ((ExportPackageAttributeConfig)this.exportConfig).getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isExported = this.exportPackageAttributesToTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isExported;
    }

    private boolean exportPackageToTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ExportPackageCallable((ExportPackageConfig)this.exportConfig, listener));
    }

    private boolean exportPackageAttributesToTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ExportPackageAttributeCallable((ExportPackageAttributeConfig)this.exportConfig, listener));
    }

    private static final class ExportPackageAttributeCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ExportPackageAttributeConfig exportConfig;
        private final TaskListener listener;

        ExportPackageAttributeCallable(ExportPackageAttributeConfig exportConfig, TaskListener listener) {
            this.exportConfig = exportConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isExported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Exporting attributes of package %s to test management system...", this.exportConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isExported = tm.exportPackageAttributes(this.exportConfig.getFilePath(), this.exportConfig.getParsedTimeout());
                if (isExported) {
                    logger.logInfo("-> Package attributes exported successfully.");
                }
            }
            catch (ETComException e) {
                logger.logError("-> Exporting package attributes failed: " + e.getMessage());
            }
            return isExported;
        }
    }

    private static final class ExportPackageCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ExportPackageConfig exportConfig;
        private final TaskListener listener;

        ExportPackageCallable(ExportPackageConfig exportConfig, TaskListener listener) {
            this.exportConfig = exportConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isExported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Exporting package %s to test management system...", this.exportConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isExported = tm.exportPackage(this.exportConfig.getFilePath(), this.exportConfig.getExportPath(), this.exportConfig.isCreateNewPath(), this.exportConfig.getParsedTimeout());
                if (isExported) {
                    logger.logInfo(String.format("-> Package exported successfully to target directory %s.", this.exportConfig.getExportPath()));
                }
            }
            catch (ETComException e) {
                logger.logError("-> Exporting package failed: " + e.getMessage());
            }
            return isExported;
        }
    }
}

