/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractTMSClient {
    public boolean login(StandardUsernamePasswordCredentials credentials, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new LoginTMSCallable(credentials, listener));
    }

    public boolean logout(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new LogoutTMSCallable(listener));
    }

    protected boolean isCompatible(ETPlugin.ToolVersion minVersion, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        return (Boolean)launcher.getChannel().call((Callable)new CompatibleTMSCallable(minVersion, listener));
    }

    private static final class LogoutTMSCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;

        LogoutTMSCallable(TaskListener listener) {
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isLogout = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Log out from test management system...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isLogout = tm.logout();
                if (isLogout) {
                    logger.logInfo("-> Logged out successfully.");
                } else {
                    logger.logError("-> Logout failed!");
                }
            }
            catch (ETComException e) {
                logger.logError("-> Logout failed: " + e.getMessage());
            }
            return isLogout;
        }
    }

    private static final class LoginTMSCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final StandardUsernamePasswordCredentials credentials;
        private final TaskListener listener;

        LoginTMSCallable(StandardUsernamePasswordCredentials credentials, TaskListener listener) {
            this.credentials = credentials;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isLogin = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Log in to test management system...");
            if (this.credentials == null) {
                logger.logError("-> No credentials provided!");
            } else {
                String progId = ETComProperty.getInstance().getProgId();
                try (ETComClient comClient = new ETComClient(progId);){
                    TestManagement tm = (TestManagement)comClient.getTestManagement();
                    logger.logInfo("-- Authenticating with user name: " + this.credentials.getUsername());
                    isLogin = tm.login(this.credentials.getUsername(), this.credentials.getPassword().getPlainText());
                    if (isLogin) {
                        logger.logInfo("-> Logged in successfully.");
                    } else {
                        logger.logError("-> Login failed due to invalid credentials!");
                    }
                }
                catch (ETComException e) {
                    logger.logError("-> Login failed: " + e.getMessage());
                }
            }
            return isLogin;
        }
    }

    private static final class CompatibleTMSCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final ETPlugin.ToolVersion minVersion;

        CompatibleTMSCallable(ETPlugin.ToolVersion minVersion, TaskListener listener) {
            this.listener = listener;
            this.minVersion = minVersion;
        }

        public Boolean call() throws IOException {
            boolean isAvailable = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                String comVersion = comClient.getVersion();
                ETPlugin.ToolVersion comToolVersion = ETPlugin.ToolVersion.parse(comVersion);
                if (comToolVersion.compareTo(this.minVersion) < 0) {
                    logger.logError(String.format("The configured ECU-TEST version %s does not support this test management method. Please use at least ECU-TEST %s!", comVersion, this.minVersion.toMicroString()));
                } else if (comClient.getTestManagement() != null) {
                    isAvailable = true;
                }
            }
            catch (ETComException e) {
                logger.logError("The test management module is not available in running ECU-TEST instance! Enable it by setting the feature flag 'TEST-MANAGEMENT-SERVICE'.");
                logger.logComException(e.getMessage());
            }
            return isAvailable;
        }
    }
}

