/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.client.PackageClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ProjectClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.scan.TestPackageScanner;
import de.tracetronic.jenkins.plugins.ecutest.test.scan.TestProjectScanner;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TestFolderBuilder
extends AbstractTestBuilder {
    protected static final ScanMode DEFAULT_SCANMODE = ScanMode.PACKAGES_AND_PROJECTS;
    @Nonnull
    private ScanMode scanMode = DEFAULT_SCANMODE;
    private boolean recursiveScan;
    @Nonnull
    private PackageConfig packageConfig = PackageConfig.newInstance();
    @Nonnull
    private ProjectConfig projectConfig = ProjectConfig.newInstance();

    @DataBoundConstructor
    public TestFolderBuilder(@Nonnull String testFile) {
        super(testFile);
    }

    @Nonnull
    public ScanMode getScanMode() {
        return this.scanMode;
    }

    public boolean isRecursiveScan() {
        return this.recursiveScan;
    }

    @Nonnull
    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    @Nonnull
    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @DataBoundSetter
    public void setScanMode(@Nonnull ScanMode scanMode) {
        this.scanMode = scanMode;
    }

    @DataBoundSetter
    public void setRecursiveScan(boolean recursiveScan) {
        this.recursiveScan = recursiveScan;
    }

    @DataBoundSetter
    public void setPackageConfig(@CheckForNull PackageConfig packageConfig) {
        this.packageConfig = packageConfig == null ? PackageConfig.newInstance() : packageConfig;
    }

    @DataBoundSetter
    public void setProjectConfig(@CheckForNull ProjectConfig projectConfig) {
        this.projectConfig = projectConfig == null ? ProjectConfig.newInstance() : projectConfig;
    }

    @Override
    protected String getTestFilePath(String testFile, String pkgDir, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String testFolderPath = null;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (testFile.isEmpty()) {
            logger.logError("No test folder declared!");
        } else {
            File fullTestFolder = new File(pkgDir, testFile);
            FilePath fullTestFolderPath = new FilePath(launcher.getChannel(), fullTestFolder.getPath());
            if (fullTestFolderPath.exists()) {
                testFolderPath = fullTestFolderPath.getRemote();
            } else {
                logger.logError(String.format("%s does not exist!", fullTestFolderPath.getRemote()));
            }
        }
        return testFolderPath;
    }

    @Override
    protected boolean runTest(String testFolder, TestConfig testConfig, ExecutionConfig executionConfig, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo("Executing test folder...");
        logger.logInfo(String.format("- Scanning test folder: %s", testFolder));
        List<String> pkgFiles = this.scanPackages(testFolder, launcher, listener);
        List<String> prjFiles = this.scanProjects(testFolder, launcher, listener);
        EnvVars buildEnv = run.getEnvironment(listener);
        PackageConfig packageConfig = this.getPackageConfig().expand(buildEnv);
        for (String pkgFile : pkgFiles) {
            PackageClient testClient = new PackageClient(pkgFile, testConfig, packageConfig, executionConfig);
            logger.logInfo(String.format("Executing package %s...", pkgFile));
            if (testClient.runTestCase(workspace, launcher, listener)) {
                this.addBuildAction(run, testClient);
                if (testClient.isAborted()) {
                    logger.logWarn("Package execution aborted!");
                    return false;
                }
                logger.logInfo("Package executed successfully.");
                continue;
            }
            logger.logError("Executing package failed!");
            return false;
        }
        ProjectConfig projectConfig = this.getProjectConfig().expand(buildEnv);
        for (String prjFile : prjFiles) {
            ProjectClient testClient = new ProjectClient(prjFile, testConfig, projectConfig, executionConfig);
            logger.logInfo(String.format("Executing project %s...", prjFile));
            if (testClient.runTestCase(workspace, launcher, listener)) {
                this.addBuildAction(run, testClient);
                if (testClient.isAborted()) {
                    logger.logWarn("Project execution aborted!");
                    return false;
                }
                logger.logInfo("Project executed successfully.");
                continue;
            }
            logger.logError("Executing project failed!");
            return false;
        }
        return true;
    }

    private List<String> scanPackages(String testFolder, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> pkgFiles = new ArrayList<String>();
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (this.scanMode.equals((Object)ScanMode.PACKAGES_ONLY) || this.scanMode.equals((Object)ScanMode.PACKAGES_AND_PROJECTS)) {
            TestPackageScanner scanner = new TestPackageScanner(testFolder, this.isRecursiveScan(), launcher);
            pkgFiles = scanner.scanTestFiles();
            if (pkgFiles.isEmpty()) {
                logger.logInfo("-> No packages found!");
            } else {
                logger.logInfo(String.format("-> Found %d package(s).", pkgFiles.size()));
            }
        }
        return pkgFiles;
    }

    private List<String> scanProjects(String testFolder, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> prjFiles = new ArrayList<String>();
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (this.scanMode.equals((Object)ScanMode.PROJECTS_ONLY) || this.scanMode.equals((Object)ScanMode.PACKAGES_AND_PROJECTS)) {
            TestProjectScanner prjScanner = new TestProjectScanner(testFolder, this.isRecursiveScan(), launcher);
            prjFiles = prjScanner.scanTestFiles();
            if (prjFiles.isEmpty()) {
                logger.logInfo("-> No projects found!");
            } else {
                logger.logInfo(String.format("-> Found %d project(s).", prjFiles.size()));
            }
        }
        return prjFiles;
    }

    @Symbol(value={"testFolder"})
    @Extension(ordinal=10000.0)
    public static final class DescriptorImpl
    extends AbstractTestDescriptor {
        public DescriptorImpl() {
            super(TestFolderBuilder.class);
            this.load();
        }

        public ScanMode getDefaultScanMode() {
            return ScanMode.PACKAGES_AND_PROJECTS;
        }

        public ListBoxModel doFillScanModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.TestFolderBuilder_ScanMode_Packages(), ScanMode.PACKAGES_ONLY.toString());
            items.add(Messages.TestFolderBuilder_ScanMode_Projects(), ScanMode.PROJECTS_ONLY.toString());
            items.add(Messages.TestFolderBuilder_ScanMode_Both(), ScanMode.PACKAGES_AND_PROJECTS.toString());
            return items;
        }

        @Override
        public FormValidation doCheckTestFile(@QueryParameter String value) {
            return this.testValidator.validateTestFolder(value);
        }

        public String getDisplayName() {
            return Messages.TestFolderBuilder_DisplayName();
        }
    }

    public static enum ScanMode {
        PACKAGES_ONLY,
        PROJECTS_ONLY,
        PACKAGES_AND_PROJECTS;

    }
}

