/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.ta;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.AnalysisEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.AnalysisExecutionInfo;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;

public class TraceAnalysisRunner {
    public List<FilePath> runAnalysis(List<FilePath> analysisFiles, boolean createReportDir, int timeout, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (List)launcher.getChannel().call((Callable)new TraceAnalysisCallable(analysisFiles, createReportDir, timeout, listener));
    }

    public boolean mergeReports(FilePath mainReport, List<FilePath> reportFiles, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new MergeReportsCallable(mainReport, reportFiles, listener));
    }

    private static final class MergeReportsCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final FilePath mainReport;
        private final List<FilePath> jobReports;
        private final TaskListener listener;

        MergeReportsCallable(FilePath mainReport, List<FilePath> jobReports, TaskListener listener) {
            this.mainReport = mainReport;
            this.jobReports = jobReports;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isMerged = true;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 AnalysisEnvironment analysisEnv = (AnalysisEnvironment)comClient.getAnalysisEnvironment();){
                List<String> jobFiles = this.getJobFiles(this.jobReports);
                logger.logInfo(String.format("- Merging analysis reports into main report: %s", this.mainReport.getRemote()));
                isMerged = analysisEnv.mergeJobReports(this.mainReport.getRemote(), jobFiles);
            }
            catch (ETComException e) {
                isMerged = false;
                logger.logError("Caught ComException: " + e.getMessage());
            }
            return isMerged;
        }

        private List<String> getJobFiles(List<FilePath> jobReports) {
            ArrayList<String> jobFiles = new ArrayList<String>();
            for (FilePath jobReport : jobReports) {
                jobFiles.add(jobReport.getRemote());
            }
            return jobFiles;
        }
    }

    private static final class TraceAnalysisCallable
    extends MasterToSlaveCallable<List<FilePath>, IOException> {
        private static final long serialVersionUID = 1L;
        private final List<FilePath> jobFiles;
        private final boolean createReportDir;
        private final int timeout;
        private final TaskListener listener;

        TraceAnalysisCallable(List<FilePath> jobFiles, boolean createReportDir, int timeout, TaskListener listener) {
            this.jobFiles = jobFiles;
            this.createReportDir = createReportDir;
            this.timeout = timeout;
            this.listener = listener;
        }

        public List<FilePath> call() throws IOException {
            ArrayList<FilePath> reportFiles = new ArrayList<FilePath>();
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 AnalysisEnvironment analysisEnv = (AnalysisEnvironment)comClient.getAnalysisEnvironment();){
                for (FilePath jobFile : this.jobFiles) {
                    logger.logInfo(String.format("- Running trace analysis: %s", jobFile.getRemote()));
                    AnalysisExecutionInfo execInfo = (AnalysisExecutionInfo)analysisEnv.executeJob(jobFile.getRemote(), this.createReportDir);
                    int tickCounter = 0;
                    long endTimeMillis = System.currentTimeMillis() + Long.valueOf(this.timeout) * 1000L;
                    while ("RUNNING".equals(execInfo.getState())) {
                        if (tickCounter % 60 == 0) {
                            logger.logInfo("-- tick...");
                        }
                        if (this.timeout > 0 && System.currentTimeMillis() > endTimeMillis) {
                            logger.logWarn(String.format("-> Analysis execution timeout of %d seconds reached! Aborting trace analysis now...", this.timeout));
                            execInfo.abort();
                            break;
                        }
                        Thread.sleep(1000L);
                        ++tickCounter;
                    }
                    this.getTestInfo(execInfo, logger);
                    reportFiles.add(jobFile.child(execInfo.getReportDb()));
                }
            }
            catch (ETComException | InterruptedException e) {
                logger.logError("Caught ComException: " + e.getMessage());
            }
            return reportFiles;
        }

        private void getTestInfo(AnalysisExecutionInfo execInfo, TTConsoleLogger logger) throws ETComException {
            String testResult = execInfo.getResult();
            logger.logInfo(String.format("-> Analysis execution completed with result: %s", testResult));
            String testReportDir = new File(execInfo.getReportDb()).getParentFile().getAbsolutePath();
            logger.logInfo(String.format("-> Test report directory: %s", testReportDir));
        }
    }
}

