/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.log;

import de.tracetronic.jenkins.plugins.ecutest.report.log.AbstractETLogAction;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogAnnotation;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class ETLogParser {
    private static final Logger LOGGER = Logger.getLogger(ETLogParser.class.getName());
    private static final String LOG_PATTERN = "^[^\\s]+(.*)";
    private static final String WARNING_PATTERN = "^[^\\s]+(.*)WARNING:$";
    private static final String ERROR_PATTERN = "^[^\\s]+(.*)ERROR:$";
    private final FilePath logFile;

    public ETLogParser(FilePath logFile) {
        this.logFile = logFile;
    }

    public List<ETLogAnnotation> parse() {
        ArrayList<ETLogAnnotation> logReports = new ArrayList<ETLogAnnotation>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.logFile.read(), Charset.forName("UTF-8")));){
            int warnLogCount = 0;
            int errorLogCount = 0;
            int maxLogCount = AbstractETLogAction.getMaxLogSize();
            try (LineNumberReader lineReader = new LineNumberReader(reader);){
                String line;
                while ((line = lineReader.readLine()) != null && (warnLogCount < maxLogCount || errorLogCount < maxLogCount)) {
                    ETLogAnnotation logAnnotation = null;
                    if (warnLogCount < maxLogCount && this.isWarningLog(line)) {
                        logAnnotation = this.parseLine(line, lineReader, ETLogAnnotation.Severity.WARNING);
                        ++warnLogCount;
                    } else if (errorLogCount < maxLogCount && this.isErrorLog(line)) {
                        logAnnotation = this.parseLine(line, lineReader, ETLogAnnotation.Severity.ERROR);
                        ++errorLogCount;
                    }
                    if (logAnnotation == null) continue;
                    logReports.add(logAnnotation);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed parsing log file %s: %s", this.logFile.getRemote(), e.getMessage()));
        }
        return logReports;
    }

    public int parseLogCount(ETLogAnnotation.Severity severity) {
        int logCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.logFile.read(), Charset.forName("UTF-8")));
             LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            while ((line = lineReader.readLine()) != null) {
                if ((severity != ETLogAnnotation.Severity.WARNING || !this.isWarningLog(line)) && (severity != ETLogAnnotation.Severity.ERROR || !this.isErrorLog(line))) continue;
                ++logCount;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed parsing log file %s: %s", this.logFile.getRemote(), e.getMessage()));
        }
        return logCount;
    }

    @CheckForNull
    private ETLogAnnotation parseLine(String line, LineNumberReader lineReader, ETLogAnnotation.Severity severity) throws IOException {
        String[] lineSplit;
        ETLogAnnotation logAnnotation = null;
        if (line != null && (lineSplit = line.split("\\s+")).length == 5) {
            int lineNumber = lineReader.getLineNumber();
            StringBuilder msg = new StringBuilder();
            while ((line = lineReader.readLine()) != null) {
                if (Pattern.matches(LOG_PATTERN, line)) {
                    if (!lineReader.markSupported()) break;
                    lineReader.reset();
                    break;
                }
                if (StringUtils.isNotBlank((String)line)) {
                    msg.append(line.trim() + "\n");
                }
                lineReader.mark(4096);
            }
            logAnnotation = new ETLogAnnotation(lineNumber, lineSplit[0] + " " + lineSplit[1], lineSplit[3], severity, msg.toString());
        }
        return logAnnotation;
    }

    private boolean isWarningLog(String line) {
        return Pattern.matches(WARNING_PATTERN, line);
    }

    private boolean isErrorLog(String line) {
        return Pattern.matches(ERROR_PATTERN, line);
    }
}

