/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXTextSetting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class ATXSettingParser {
    private static final Logger LOGGER = Logger.getLogger(ATXSetting.class.getName());
    private static final String PRECEDING_COMMENT = "//SETTINGS//*[preceding-sibling::comment()[1]";
    private static final String UPLOAD_EXPRESSION = "//SETTINGS//*[preceding-sibling::comment()[1][.=' Uploadeinstellungen ']]";
    private static final String ARCHIVE_EXPRESSION = "//SETTINGS//*[preceding-sibling::comment()[1][.=' Archiveinstellungen ']]";
    private static final String ATTRIBUTE_EXPRESSION = "//SETTINGS//*[preceding-sibling::comment()[1][.=' Attributeinstellungen ']]";
    private static final String TCF_CONSTANT_EXPRESSION = "//SETTINGS//*[preceding-sibling::comment()[1][.=' TCF-Globale Konstanteneinstellungen ']]";
    private static final String SPECIAL_EXPRESSION = "//SETTINGS//*[preceding-sibling::comment()[1][.=' Spezielle Einstellungen ']]";

    private ATXSettingParser() {
    }

    public static Map<String, List<ATXSetting>> parseSettings(Document doc) {
        LinkedHashMap<String, List<ATXSetting>> configMap = new LinkedHashMap<String, List<ATXSetting>>();
        List<ATXSetting> uploadSettings = ATXSettingParser.parseSetting(doc, UPLOAD_EXPRESSION);
        List<ATXSetting> archiveSettings = ATXSettingParser.parseSetting(doc, ARCHIVE_EXPRESSION);
        List<ATXSetting> attributeSettings = ATXSettingParser.parseSetting(doc, ATTRIBUTE_EXPRESSION);
        List<ATXSetting> tcfConstantSettings = ATXSettingParser.parseSetting(doc, TCF_CONSTANT_EXPRESSION);
        List<ATXSetting> specialSettings = ATXSettingParser.parseSetting(doc, SPECIAL_EXPRESSION);
        configMap.put("uploadConfig", uploadSettings);
        configMap.put("archiveConfig", archiveSettings);
        configMap.put("attributeConfig", attributeSettings);
        configMap.put("tcfConstantConfig", tcfConstantSettings);
        configMap.put("specialConfig", specialSettings);
        return configMap;
    }

    public static List<ATXSetting> parseSetting(Document doc, String expression) {
        ArrayList<ATXSetting> settings = new ArrayList<ATXSetting>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xpath.compile(expression);
            NodeList settingNodes = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < settingNodes.getLength(); ++i) {
                ATXSetting setting;
                Node settingNode = settingNodes.item(i);
                ATXSettingParser.removeWhitespaceNodes((Element)settingNode);
                String settingName = ATXSettingParser.parseAttribute(settingNode, "name");
                String defaultValue = ATXSettingParser.parseAttribute(settingNode, "default");
                String descGerman = ATXSettingParser.parseDescription(settingNode, "de_DE");
                String descEnglish = ATXSettingParser.parseDescription(settingNode, "en_US");
                boolean isCheckbox = ATXSettingParser.isCheckbox(defaultValue);
                if (isCheckbox) {
                    setting = new ATXBooleanSetting(settingName, descGerman, descEnglish, ATXSettingParser.toBoolean(defaultValue));
                    settings.add(setting);
                    continue;
                }
                setting = new ATXTextSetting(settingName, descGerman, descEnglish, defaultValue);
                settings.add(setting);
            }
        }
        catch (IllegalArgumentException | NullPointerException | XPathExpressionException e) {
            LOGGER.log(Level.SEVERE, "Error parsing setting: " + e.getMessage(), e);
        }
        return settings;
    }

    private static String parseDescription(Node node, String languageKey) {
        String description = "";
        String expression = "./DESCRIPTION/MULTILANGDATA/ELEMENT[@dkey='" + languageKey + "']/DVALUE";
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xpath.compile(expression);
            Node descNode = (Node)xPathExpression.evaluate(node, XPathConstants.NODE);
            if (descNode != null) {
                description = descNode.getTextContent().replaceAll("\\s+", " ").trim();
            }
        }
        catch (IllegalArgumentException | NullPointerException | XPathExpressionException e) {
            LOGGER.log(Level.SEVERE, "Error parsing description: " + e.getMessage(), e);
        }
        return description;
    }

    private static String parseAttribute(Node node, String attrName) {
        return node.getAttributes().getNamedItem(attrName).getTextContent().replaceAll("\\s+", " ").trim();
    }

    private static boolean isCheckbox(String defaultValue) {
        boolean isCheckbox = "true".equals(defaultValue.toLowerCase(Locale.getDefault())) || "false".equals(defaultValue.toLowerCase(Locale.getDefault()));
        return isCheckbox;
    }

    private static boolean toBoolean(String value) {
        return "true".equals(value.toLowerCase(Locale.getDefault()));
    }

    private static void removeWhitespaceNodes(Element elem) {
        NodeList children = elem.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                elem.removeChild(child);
                continue;
            }
            if (child instanceof Text) continue;
            ATXSettingParser.removeWhitespaceNodes((Element)child);
        }
    }
}

