/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ATXInstallation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String toolName;
    private final ATXConfig config;

    @DataBoundConstructor
    public ATXInstallation(String name, String toolName, ATXConfig config) {
        this.name = StringUtils.trimToEmpty((String)name);
        this.toolName = toolName;
        this.config = config == null ? new ATXConfig() : config;
    }

    public String getName() {
        return this.name;
    }

    public String getToolName() {
        return this.toolName;
    }

    public ATXConfig getConfig() {
        return this.config;
    }

    public static final ATXInstallation[] all() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return new ATXInstallation[0];
        }
        ATXPublisher.DescriptorImpl atxDescriptor = (ATXPublisher.DescriptorImpl)instance.getDescriptorByType(ATXPublisher.DescriptorImpl.class);
        return atxDescriptor.getInstallations();
    }

    @CheckForNull
    public static final ATXInstallation get(String name) {
        ATXInstallation[] installations;
        for (ATXInstallation installation : installations = ATXInstallation.all()) {
            if (!StringUtils.equals((String)name, (String)installation.getName())) continue;
            return installation;
        }
        return null;
    }
}

