/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportAction;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.tools.ToolInstallation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractReportPublisher
extends Recorder
implements SimpleBuildStep {
    private boolean allowMissing;
    private boolean runOnFailed;
    private Boolean archiving = true;
    private Boolean keepAll = true;
    private transient boolean downstream;
    private transient String workspace;
    private transient TTConsoleLogger logger;

    public AbstractReportPublisher() {
    }

    public AbstractReportPublisher(boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        this.allowMissing = allowMissing;
        this.runOnFailed = runOnFailed;
        this.archiving = archiving;
        this.keepAll = keepAll;
    }

    public boolean isAllowMissing() {
        return this.allowMissing;
    }

    public boolean isRunOnFailed() {
        return this.runOnFailed;
    }

    public Boolean isArchiving() {
        return this.archiving;
    }

    public boolean getArchiving() {
        return this.archiving;
    }

    public Boolean isKeepAll() {
        return this.keepAll;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    @DataBoundSetter
    public void setAllowMissing(boolean allowMissing) {
        this.allowMissing = allowMissing;
    }

    @DataBoundSetter
    public void setRunOnFailed(boolean runOnFailed) {
        this.runOnFailed = runOnFailed;
    }

    @DataBoundSetter
    public void setArchiving(boolean archiving) {
        this.archiving = archiving;
    }

    @DataBoundSetter
    public void setKeepAll(boolean keepAll) {
        this.keepAll = keepAll;
    }

    public boolean isDownstream() {
        return this.downstream;
    }

    public void setDownstream(boolean downstream) {
        this.downstream = downstream;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            this.initLogger(listener);
            this.performReport(run, workspace, launcher, listener);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            this.getLogger().logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    protected abstract void performReport(Run<?, ?> var1, FilePath var2, Launcher var3, TaskListener var4) throws InterruptedException, IOException, ETPluginException;

    protected TTConsoleLogger getLogger() {
        return this.logger != null ? this.logger : new TTConsoleLogger(TaskListener.NULL);
    }

    private void initLogger(TaskListener listener) {
        this.logger = new TTConsoleLogger(listener);
    }

    protected boolean isSkipped(boolean checkOS, Run<?, ?> run, Launcher launcher) throws ETPluginException {
        Result buildResult;
        if (checkOS) {
            ProcessUtil.checkOS(launcher);
        }
        if ((buildResult = run.getResult()) != null && !this.canContinue(buildResult)) {
            this.getLogger().logInfo(String.format("Skipping publisher since build result is %s", buildResult));
            return true;
        }
        return false;
    }

    protected boolean canContinue(Result result) {
        if (this.isRunOnFailed()) {
            return result.isBetterThan(Result.ABORTED);
        }
        return result.isBetterThan(Result.FAILURE);
    }

    protected boolean isETRunning(Launcher launcher) throws IOException, InterruptedException {
        List<String> foundProcesses = ETClient.checkProcesses(launcher, false);
        return !foundProcesses.isEmpty();
    }

    protected ETClient getToolClient(String toolName, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException, ETPluginException {
        ETInstallation installation = this.configureToolInstallation(toolName, workspace.toComputer(), listener, run.getEnvironment(listener));
        String installPath = installation.getExecutable(launcher);
        String workspaceDir = this.getWorkspaceDir(run, workspace);
        String settingsDir = this.getSettingsDir(run, workspace);
        String expandedToolName = run.getEnvironment(listener).expand(installation.getName());
        return new ETClient(expandedToolName, installPath, workspaceDir, settingsDir, 120, false);
    }

    protected ETInstallation configureToolInstallation(String toolName, Computer computer, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, ETPluginException {
        ETInstallation installation = this.getToolInstallation(toolName, envVars);
        if (installation != null && computer != null) {
            Node node = computer.getNode();
            if (node != null) {
                installation = installation.forNode(node, listener);
                installation = installation.forEnvironment(envVars);
            }
        } else {
            throw new ETPluginException("The selected ECU-TEST installation is not configured for this node!");
        }
        ETComProperty.getInstance().setProgId(installation.getProgId());
        ETComProperty.getInstance().setTimeout(installation.getTimeout());
        return installation;
    }

    public ETInstallation getToolInstallation(String toolName, EnvVars envVars) {
        String expToolName = envVars.expand(toolName);
        return this.getToolDescriptor().getInstallation(expToolName);
    }

    public ETInstallation.DescriptorImpl getToolDescriptor() {
        return (ETInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(ETInstallation.DescriptorImpl.class));
    }

    protected String getWorkspaceDir(Run<?, ?> run, FilePath workspace) {
        ToolEnvInvisibleAction toolEnvAction = (ToolEnvInvisibleAction)run.getAction(ToolEnvInvisibleAction.class);
        String workspaceDir = toolEnvAction != null ? toolEnvAction.getToolWorkspace() : (this.isDownstream() ? workspace.child(this.getWorkspace()).getRemote() : "");
        return workspaceDir;
    }

    protected String getSettingsDir(Run<?, ?> run, FilePath workspace) {
        ToolEnvInvisibleAction toolEnvAction = (ToolEnvInvisibleAction)run.getAction(ToolEnvInvisibleAction.class);
        String settingsDir = toolEnvAction != null ? toolEnvAction.getToolSettings() : (this.isDownstream() ? workspace.child(this.getWorkspace()).getRemote() : "");
        return settingsDir;
    }

    protected FilePath getArchiveTarget(Run<?, ?> run) {
        return new FilePath(this.isKeepAll() != false ? this.getBuildArchiveDir(run) : this.getProjectArchiveDir((AbstractItem)run.getParent()));
    }

    private File getProjectArchiveDir(AbstractItem project) {
        return new File(project.getRootDir(), this.getUrlName());
    }

    private File getBuildArchiveDir(Run<?, ?> run) {
        return new File(run.getRootDir(), this.getUrlName());
    }

    protected abstract String getUrlName();

    protected List<FilePath> getReportDirs(Run<?, ?> run, FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        ArrayList<FilePath> reportDirs = new ArrayList<FilePath>();
        if (this.isDownstream()) {
            FilePath reportDir;
            FilePath wsDir = workspace.child(this.getWorkspace());
            if (wsDir.exists() && (reportDir = wsDir.child("TestReports")).exists()) {
                reportDirs.addAll(reportDir.listDirectories());
            }
        } else {
            List testEnvActions = run.getActions(TestEnvInvisibleAction.class);
            for (TestEnvInvisibleAction testEnvAction : testEnvActions) {
                FilePath reportDir = new FilePath(launcher.getChannel(), testEnvAction.getTestReportDir());
                if (!reportDir.exists()) continue;
                reportDirs.add(reportDir);
            }
        }
        return reportDirs;
    }

    protected List<FilePath> getReportFiles(Run<?, ?> run, FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        return this.getReportFiles("**/*.trf", "*/**/Job_*.trf", run, workspace, launcher);
    }

    protected List<FilePath> getReportFiles(String includes, String excludes, Run<?, ?> run, FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        ArrayList<FilePath> reportFiles = new ArrayList<FilePath>();
        List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
        for (FilePath reportDir : reportDirs) {
            reportFiles.addAll(Arrays.asList(reportDir.list(includes, excludes)));
        }
        Collections.reverse(reportFiles);
        return reportFiles;
    }

    protected long getFileSize(FilePath file) throws IOException, InterruptedException {
        return file.length();
    }

    protected long getDirectorySize(FilePath directory) throws IOException, InterruptedException {
        FilePath[] files;
        long size = 0L;
        for (FilePath file : files = directory.list("**")) {
            size += file.length();
        }
        return size;
    }

    @CheckForNull
    public static FilePath getFirstReportFile(FilePath reportDir) throws IOException, InterruptedException {
        FilePath[] files = reportDir.list("*.trf", "Job_*.trf");
        return files.length > 0 ? files[0] : null;
    }

    public static void removePreviousReports(Run<?, ?> run, Class<? extends AbstractReportAction> clazz) throws IOException {
        for (Run prevBuild = run.getPreviousBuild(); prevBuild != null; prevBuild = prevBuild.getPreviousBuild()) {
            AbstractReportAction buildAction = (AbstractReportAction)prevBuild.getAction(clazz);
            if (buildAction == null || !buildAction.isProjectLevel()) continue;
            prevBuild.getActions().remove(buildAction);
            prevBuild.save();
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public AbstractReportDescriptor getDescriptor() {
        return (AbstractReportDescriptor)super.getDescriptor();
    }
}

