/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.slave;

import hudson.Extension;
import java.io.IOException;
import jenkins.slaves.restarter.SlaveRestarter;

@Extension
public class WindowsTaskSlaveRestarter
extends SlaveRestarter {
    private static final long serialVersionUID = 1L;
    private static final String TASKNAME = "RESTART_JENKINS_SLAVE";

    public boolean canWork() {
        try {
            int ret = this.queryTask();
            return ret == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    public void restart() throws Exception {
        int ret = this.execTask();
        throw new IOException("Failed restarting slave!\nTask completed with exit value: " + ret);
    }

    private int queryTask() throws InterruptedException, IOException {
        return this.runProcess("/query");
    }

    private int execTask() throws InterruptedException, IOException {
        return this.runProcess("/run");
    }

    private int runProcess(String option) throws IOException, InterruptedException {
        ProcessBuilder procBuilder = new ProcessBuilder("schtasks.exe", option, "/tn", TASKNAME);
        Process proc = procBuilder.start();
        return proc.waitFor();
    }
}

