/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl;

import com.google.common.base.Preconditions;
import de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl.AbstractToolBuilderDslExtension;
import de.tracetronic.jenkins.plugins.ecutest.tool.StartETBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StartTSBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StopETBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StopTSBuilder;
import hudson.Extension;
import hudson.util.FormValidation;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.step.StepContext;
import javaposse.jobdsl.plugin.DslExtensionMethod;

@Extension(optional=true)
public class ToolBuilderDslExtension
extends AbstractToolBuilderDslExtension {
    private static final String OPT_WORKSPACE_DIR = "workspaceDir";
    private static final String OPT_SETTINGS_DIR = "settingsDir";

    @DslExtensionMethod(context=StepContext.class)
    public Object startET(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        StartETContext context = new StartETContext();
        ToolBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        StartETBuilder builder = new StartETBuilder(toolName.toString());
        builder.setWorkspaceDir(context.workspaceDir);
        builder.setSettingsDir(context.settingsDir);
        builder.setTimeout(context.timeout);
        builder.setDebugMode(context.debugMode);
        builder.setKeepInstance(context.keepInstance);
        this.checkToolInstallation(toolName.toString(), builder);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object startET(CharSequence toolName) {
        return this.startET(toolName, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object stopET(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        StopETContext context = new StopETContext();
        ToolBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        StopETBuilder builder = new StopETBuilder(toolName.toString());
        builder.setTimeout(context.timeout);
        this.checkToolInstallation(toolName.toString(), builder);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object stopET(CharSequence toolName) {
        return this.stopET(toolName, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object startTS(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        StartTSContext context = new StartTSContext();
        ToolBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        StartTSBuilder builder = new StartTSBuilder(toolName.toString());
        builder.setToolLibsIni(context.toolLibsIni);
        builder.setTcpPort(context.tcpPort);
        builder.setTimeout(context.timeout);
        builder.setKeepInstance(context.keepInstance);
        this.checkToolInstallation(toolName.toString(), builder);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object startTS(CharSequence toolName) {
        return this.startTS(toolName, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object stopTS(CharSequence toolName, Runnable closure) {
        Preconditions.checkNotNull((Object)toolName, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"toolName"});
        StopTSContext context = new StopTSContext();
        ToolBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        StopTSBuilder builder = new StopTSBuilder(toolName.toString());
        builder.setTimeout(context.timeout);
        this.checkToolInstallation(toolName.toString(), builder);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object stopTS(CharSequence toolName) {
        return this.stopTS(toolName, null);
    }

    public class StopTSContext
    extends AbstractToolBuilderDslExtension.AbstractToolContext {
        @Override
        protected int getDefaultTimeout() {
            return 30;
        }
    }

    public class StartTSContext
    extends AbstractToolBuilderDslExtension.AbstractToolContext {
        private static final String OPT_TOOLLIBS_INI = "toolLibsIni";
        private static final String OPT_TCP_PORT = "tcpPort";
        private String toolLibsIni;
        private String tcpPort;
        private boolean keepInstance;

        @Override
        protected int getDefaultTimeout() {
            return 120;
        }

        public void toolLibsIni(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_TOOLLIBS_INI});
            FormValidation validation = ToolBuilderDslExtension.this.validator.validateToolLibsIni(value.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.toolLibsIni = value.toString();
        }

        public void tcpPort(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_TCP_PORT});
            FormValidation validation = ToolBuilderDslExtension.this.validator.validateTcpPort(value.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.tcpPort = value.toString();
        }

        public void tcpPort(int value) {
            this.tcpPort(String.valueOf((Object)value));
        }

        public void keepInstance(boolean value) {
            this.keepInstance = value;
        }
    }

    public class StopETContext
    extends AbstractToolBuilderDslExtension.AbstractToolContext {
        @Override
        protected int getDefaultTimeout() {
            return 30;
        }
    }

    public class StartETContext
    extends AbstractToolBuilderDslExtension.AbstractToolContext {
        private String workspaceDir;
        private String settingsDir;
        private boolean debugMode;
        private boolean keepInstance;

        @Override
        protected int getDefaultTimeout() {
            return 120;
        }

        public void workspaceDir(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{ToolBuilderDslExtension.OPT_WORKSPACE_DIR});
            FormValidation validation = ToolBuilderDslExtension.this.validator.validateWorkspaceDir(value.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.workspaceDir = value.toString();
        }

        public void settingsDir(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{ToolBuilderDslExtension.OPT_SETTINGS_DIR});
            FormValidation validation = ToolBuilderDslExtension.this.validator.validateSettingsDir(value.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.settingsDir = value.toString();
        }

        public void debugMode(boolean value) {
            this.debugMode = value;
        }

        public void keepInstance(boolean value) {
            this.keepInstance = value;
        }
    }
}

