/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env;

import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.PackageClient;
import hudson.model.InvisibleAction;

public class TestEnvInvisibleAction
extends InvisibleAction {
    private final int testId;
    private final String testName;
    private final TestType testType;
    private final String testDescription;
    private final String testFile;
    private final String testTbc;
    private final String testTcf;
    private final String testReportDir;
    private final String testResult;
    private final int timeout;

    public TestEnvInvisibleAction(int testId, AbstractTestClient testClient) {
        this.testId = testId;
        this.testName = testClient.getTestName();
        this.testType = testClient instanceof PackageClient ? TestType.PACKAGE : TestType.PROJECT;
        this.testDescription = testClient.getTestDescription();
        this.testFile = testClient.getTestFile();
        this.testTbc = testClient.getTestConfig().getTbcFile();
        this.testTcf = testClient.getTestConfig().getTcfFile();
        this.testReportDir = testClient.getTestReportDir();
        this.testResult = testClient.getTestResult();
        this.timeout = testClient.getExecutionConfig().getParsedTimeout();
    }

    public int getTestId() {
        return this.testId;
    }

    public String getTestName() {
        return this.testName;
    }

    public TestType getTestType() {
        return this.testType;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public String getTestFile() {
        return this.testFile;
    }

    public String getTestTbc() {
        return this.testTbc;
    }

    public String getTestTcf() {
        return this.testTcf;
    }

    public String getTestReportDir() {
        return this.testReportDir;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static enum TestType {
        PACKAGE,
        PROJECT;

    }
}

