/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectDirConfig;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;

public class ETPlugin {
    public static final ToolVersion ET_MIN_VERSION = new ToolVersion(6, 3, 0, 0L);
    public static final ToolVersion ET_MAX_VERSION = new ToolVersion(7, 1, 0, 0L);
    public static final ToolVersion ATX_VERSION = new ToolVersion(1, 57, 1, 0L);

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        String configPath = "de.tracetronic.jenkins.plugins.ecutest.test.config.";
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageTMSConfig", ImportPackageConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageTMSDirConfig", ImportPackageDirConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectTMSConfig", ImportProjectConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectTMSDirConfig", ImportProjectDirConfig.class);
        for (Map.Entry entry : classMap.entrySet()) {
            Items.XSTREAM2.addCompatibilityAlias((String)entry.getKey(), (Class)entry.getValue());
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public void syncATXConfiguration() {
        ATXPublisher.DescriptorImpl descriptor = (ATXPublisher.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(ATXPublisher.DescriptorImpl.class);
        if (descriptor != null) {
            descriptor.syncWithDefaultConfig();
        }
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void registerIcons() {
        for (String name : new String[]{"atx-report", "atx-trend", "ecu-test", "ecu-test-pkg", "ecu-test-prj", "report-generator", "test-guide", "test-param", "tool-param", "trf-report", "trace-check", "trace-report"}) {
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-sm", name), String.format("ecutest/icons/16x16/%s.png", name), "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-md", name), String.format("ecutest/icons/24x24/%s.png", name), "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-lg", name), String.format("ecutest/icons/32x32/%s.png", name), "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-xlg", name), String.format("ecutest/icons/48x48/%s.png", name), "width: 48px; height: 48px;", IconType.PLUGIN));
        }
    }

    public static String getIconFileName(String iconClassName, String iconStyle) {
        String iconClass = iconClassName + " " + iconStyle;
        try {
            Method getIconByClassSpec = IconSet.class.getMethod("getIconByClassSpec", Object.class);
            return ((Icon)getIconByClassSpec.invoke((Object)IconSet.icons, iconClass)).getUrl();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return IconSet.icons.getIconByClassSpec(iconClass).getUrl();
        }
    }

    public static final class ToolVersion
    implements Comparable<ToolVersion>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int major;
        private final int minor;
        private final int micro;
        private final long qualifier;

        public ToolVersion(int major, int minor, int micro, long qualifier) {
            if (major < 0 || minor < 0 || micro < 0 || qualifier < 0L) {
                throw new IllegalArgumentException("Versions must be greater than or equal to 0");
            }
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.qualifier = qualifier;
        }

        @Override
        public int compareTo(ToolVersion version) {
            if (this.major != version.major) {
                return Integer.compare(this.major, version.major);
            }
            if (this.minor != version.minor) {
                return Integer.compare(this.minor, version.minor);
            }
            if (this.micro != version.micro) {
                return Integer.compare(this.micro, version.micro);
            }
            if (this.qualifier != version.qualifier) {
                return Long.compare(this.qualifier, version.qualifier);
            }
            return 0;
        }

        public int compareWithoutMicroTo(ToolVersion version) {
            if (this.major != version.major) {
                return Integer.compare(this.major, version.major);
            }
            if (this.minor != version.minor) {
                return Integer.compare(this.minor, version.minor);
            }
            return 0;
        }

        public int compareWithoutQualifierTo(ToolVersion version) {
            if (this.major != version.major) {
                return Integer.compare(this.major, version.major);
            }
            if (this.minor != version.minor) {
                return Integer.compare(this.minor, version.minor);
            }
            if (this.micro != version.micro) {
                return Integer.compare(this.micro, version.micro);
            }
            return 0;
        }

        public String toString() {
            return String.format("%d.%d.%d.%d", this.major, this.minor, this.micro, this.qualifier);
        }

        public String toMicroString() {
            return String.format("%d.%d.%d", this.major, this.minor, this.micro);
        }

        public String toMinorString() {
            return String.format("%d.%d", this.major, this.minor);
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other instanceof ToolVersion) {
                ToolVersion that = (ToolVersion)other;
                result = this.compareTo(that) == 0;
            }
            return result;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append(this.major).append(this.minor).append(this.micro).append(this.qualifier).toHashCode();
        }

        public static ToolVersion parse(String version) throws IllegalArgumentException {
            Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\w+))?$");
            Matcher matcher = pattern.matcher(version);
            if (!matcher.find() || matcher.groupCount() != 4) {
                throw new IllegalArgumentException("Version must be in form <major>.<minor>.<micro>.<qualifier>");
            }
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int micro = Integer.parseInt(matcher.group(3));
            long qualifier = Long.parseLong(matcher.group(4));
            return new ToolVersion(major, minor, micro, qualifier);
        }
    }
}

