/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.wrapper.com;

import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.JacobException;
import com.jacob.com.Variant;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class ETComDispatch
extends Dispatch
implements AutoCloseable {
    private static final Object[] NO_PARAMS = new Object[0];
    private static final Logger LOGGER = Logger.getLogger(ETComDispatch.class.getName());
    private final boolean useTimeout;

    public ETComDispatch(boolean useTimeout) {
        super(ETComProperty.getInstance().getProgId());
        this.useTimeout = useTimeout;
    }

    public ETComDispatch(Dispatch dispatch, boolean useTimeout) {
        super(dispatch);
        this.useTimeout = useTimeout;
    }

    public boolean useTimeout() {
        return this.useTimeout;
    }

    protected Variant performRequest(String method) throws ETComException {
        return this.performRequest(method, ETComProperty.getInstance().getTimeout(), NO_PARAMS);
    }

    protected Variant performRequest(String method, int timeout) throws ETComException {
        return this.performRequest(method, timeout, NO_PARAMS);
    }

    protected Variant performRequest(String method, Object ... params) throws ETComException {
        return this.performRequest(method, ETComProperty.getInstance().getTimeout(), params);
    }

    protected Variant performRequest(String method, int timeout, Object ... params) throws ETComException {
        if (timeout == 0) {
            return this.performDirectRequest(method, params);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Variant> future = executor.submit(new DispatchCallable(method, params));
        try {
            Variant variant = future.get(timeout, TimeUnit.SECONDS);
            return variant;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new ETComTimeoutException(String.format("Request timeout of %d seconds exceeded!", timeout), e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ETComException(String.format("Error while performing request: %s", e.getMessage()), e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected Variant performDirectRequest(String method) throws ETComException {
        return this.callDispatch(method, NO_PARAMS);
    }

    protected Variant performDirectRequest(String method, Object ... params) throws ETComException {
        return this.callDispatch(method, params);
    }

    private Variant callDispatch(String method, Object ... params) throws ETComException {
        try {
            String parameters = StringUtils.join((Object[])params, (char)',');
            Variant result = Dispatch.call((Dispatch)this, (String)method, (Object[])params);
            String dispatchName = this.getClass().getSimpleName();
            LOGGER.fine(String.format("%s.call(): %s (%s) --> %s", dispatchName, method, parameters, result));
            return result;
        }
        catch (JacobException | IllegalArgumentException | IllegalStateException e) {
            throw new ETComException(e.getMessage(), e);
        }
    }

    public boolean isAttached() {
        boolean isAttached = super.isAttached();
        String dispatchName = this.getClass().getSimpleName();
        LOGGER.finer(String.format("%s.isAttached() --> %s", dispatchName, isAttached));
        return isAttached;
    }

    private void releaseDispatch() throws ETComException {
        try {
            String dispatchName = this.getClass().getSimpleName();
            LOGGER.finer(String.format("%s.safeRelease()", dispatchName));
            this.safeRelease();
        }
        catch (JacobException e) {
            throw new ETComException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.releaseDispatch();
        }
        catch (ETComException eTComException) {
        }
        finally {
            if (!this.useTimeout) {
                ComThread.Release();
            }
        }
    }

    protected void finalize() {
        if (!this.useTimeout) {
            super.finalize();
        }
    }

    private final class DispatchCallable
    implements Callable<Variant> {
        private final String method;
        private final Object[] params;

        DispatchCallable(String method, Object[] params) {
            this.method = method;
            this.params = params;
        }

        @Override
        public Variant call() throws Exception {
            if (!Thread.interrupted()) {
                return ETComDispatch.this.callDispatch(this.method, this.params);
            }
            throw new ETComException("Dispatch call is interrupted by timeout thread!");
        }
    }
}

