/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.wrapper.com;

import com.jacob.com.Dispatch;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Cache;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComDispatch;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComCache;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.api.ComCaches;

public class Caches
extends ETComDispatch
implements ComCaches {
    public Caches(Dispatch dispatch, boolean useTimeout) {
        super(dispatch, useTimeout);
    }

    public Cache getCacheByType(CacheType type) throws ETComException {
        switch (type) {
            case A2L: {
                return (Cache)this.getA2lCache();
            }
            case ELF: {
                return (Cache)this.getElfCache();
            }
            case BUS: {
                return (Cache)this.getBusCache();
            }
            case MODEL: {
                return (Cache)this.getModelCache();
            }
            case SERVICE: {
                return (Cache)this.getServiceCache();
            }
        }
        throw new ETComException("Unsupported cache type:" + type.name());
    }

    @Override
    public ComCache getA2lCache() throws ETComException {
        return new Cache(this.performRequest("GetA2lCache").toDispatch(), this.useTimeout(), CacheType.A2L);
    }

    @Override
    public ComCache getElfCache() throws ETComException {
        return new Cache(this.performRequest("GetElfCache").toDispatch(), this.useTimeout(), CacheType.ELF);
    }

    @Override
    public ComCache getBusCache() throws ETComException {
        return new Cache(this.performRequest("GetBusCache").toDispatch(), this.useTimeout(), CacheType.BUS);
    }

    @Override
    public ComCache getModelCache() throws ETComException {
        return new Cache(this.performRequest("GetModelCache").toDispatch(), this.useTimeout(), CacheType.MODEL);
    }

    @Override
    public ComCache getServiceCache() throws ETComException {
        return new Cache(this.performRequest("GetServiceCache").toDispatch(), this.useTimeout(), CacheType.SERVICE);
    }

    public static enum CacheType {
        A2L,
        ELF,
        BUS,
        MODEL,
        SERVICE;

    }
}

