/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.AbstractValidator;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ToolValidator
extends AbstractValidator {
    public FormValidation validateWorkspaceDir(String wsDir) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isBlank((String)wsDir) && wsDir.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    public FormValidation validateSettingsDir(String settingsDir) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isBlank((String)settingsDir) && settingsDir.contains("$")) {
            returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
        }
        return returnValue;
    }

    public FormValidation validateToolLibsIni(String toolLibsIni) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isBlank((String)toolLibsIni)) {
            if (toolLibsIni.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.Builder_NoValidatedValue());
            } else if (!IOUtils.isAbsolute((String)toolLibsIni) || FilenameUtils.getExtension((String)toolLibsIni).isEmpty()) {
                returnValue = FormValidation.error((String)Messages.StartTSBuilder_NoAbsolutePath());
            }
        }
        return returnValue;
    }

    public FormValidation validateTcpPort(String tcpPort) {
        FormValidation returnValue = StringUtils.isBlank((String)tcpPort) ? FormValidation.warning((String)Messages.StartTSBuilder_NoTcpPort(5017)) : (tcpPort.contains("$") ? FormValidation.warning((String)Messages.Builder_NoValidatedValue()) : FormValidation.validatePositiveInteger((String)tcpPort));
        return returnValue;
    }
}

