/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util.validation;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.Messages;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.AbstractValidator;
import hudson.Util;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.commons.lang.StringUtils;

public class ATXValidator
extends AbstractValidator {
    private static boolean isValidURL(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
        return true;
    }

    public static void ignoreSSLIssues(HttpsURLConnection connection) throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        connection.setHostnameVerifier(allHostsValid);
    }

    public FormValidation validateName(String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation validateServerUrl(String serverUrl) {
        FormValidation returnValue = FormValidation.validateRequired((String)serverUrl);
        if (returnValue == FormValidation.ok()) {
            if (serverUrl.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_NoValidatedValue());
            } else if (serverUrl.startsWith("http://") || serverUrl.startsWith("https://")) {
                returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidServerUrlProtocol());
            } else if (ATXValidator.isValidURL(serverUrl)) {
                returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidServerUrl(serverUrl));
            }
        }
        return returnValue;
    }

    public FormValidation validateServerPort(String serverPort) {
        FormValidation returnValue = FormValidation.validateRequired((String)serverPort);
        if (returnValue == FormValidation.ok()) {
            if (serverPort.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_NoValidatedValue());
            } else {
                returnValue = FormValidation.validatePositiveInteger((String)serverPort);
                if (returnValue == FormValidation.ok()) {
                    int port = Integer.parseInt(serverPort);
                    if (port > 65535) {
                        returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidPort());
                    } else if (port <= 1024) {
                        returnValue = FormValidation.warning((String)Messages.ATXInstallation_NeedsAdmin());
                    }
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateServerContextPath(String contextPath) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)contextPath)) {
            if (contextPath.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_NoValidatedValue());
            } else {
                String pattern = "^[A-Za-z0-9./\\-_]+";
                if (!Pattern.matches("^[A-Za-z0-9./\\-_]+", contextPath)) {
                    returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidServerContextPath());
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateArchiveMiscFiles(String expression) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)expression)) {
            if (expression.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_NoValidatedValue());
            } else {
                String pattern = "[A-Za-z0-9./*]+";
                for (String token : Util.tokenize((String)expression, (String)";")) {
                    if (Pattern.matches("[A-Za-z0-9./*]+", token)) continue;
                    returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidFileExpression());
                    break;
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateCoveredAttributes(String expression) {
        FormValidation returnValue = FormValidation.ok();
        if (!StringUtils.isEmpty((String)expression)) {
            if (expression.contains("$")) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_NoValidatedValue());
            } else {
                String pattern = "(Designer|Name|Status|Testlevel|Tools|VersionCounter|Design Contact|Design Department|Estimated Duration \\[min]|Execution Priority|Test Comment)";
                for (String token : Util.tokenize((String)expression, (String)";")) {
                    if (Pattern.matches("(Designer|Name|Status|Testlevel|Tools|VersionCounter|Design Contact|Design Department|Estimated Duration \\[min]|Execution Priority|Test Comment)", token)) continue;
                    returnValue = FormValidation.warning((String)Messages.ATXInstallation_CustomAttributeExpression());
                    break;
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateSetting(String name, String value) {
        FormValidation returnValue = FormValidation.ok();
        if (name != null) {
            switch (name) {
                case "serverURL": {
                    returnValue = this.validateServerUrl(value);
                    break;
                }
                case "serverPort": {
                    returnValue = this.validateServerPort(value);
                    break;
                }
                case "serverContextPath": {
                    returnValue = this.validateServerContextPath(value);
                    break;
                }
                case "archiveMiscFiles": {
                    returnValue = this.validateArchiveMiscFiles(value);
                    break;
                }
                case "coveredAttributes": {
                    returnValue = this.validateCoveredAttributes(value);
                    break;
                }
                default: {
                    returnValue = this.validateParameterizedValue(value);
                }
            }
        }
        return returnValue;
    }

    public FormValidation validateCustomSettingName(String name) {
        FormValidation returnValue = FormValidation.validateRequired((String)name);
        if (!StringUtils.isAlpha((String)name)) {
            returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidSettingName());
        } else {
            ATXConfig config;
            ATXInstallation[] installations = ATXInstallation.all();
            if (installations.length > 0 && (config = installations[0].getConfig()) != null && config.getSettingByName(name).isPresent()) {
                returnValue = FormValidation.warning((String)Messages.ATXInstallation_DuplicateSetting());
            }
        }
        return returnValue;
    }

    public FormValidation validateCustomSettingValue(String value) {
        return this.validateParameterizedValue(value);
    }

    public FormValidation testConnection(String serverUrl, String serverPort, String serverContextPath, boolean useHttpsConnection, boolean ignoreSSL) {
        String baseUrl = ATXUtil.getBaseUrl(serverUrl, serverPort, serverContextPath, useHttpsConnection);
        return this.testConnection(baseUrl, "", ignoreSSL);
    }

    public FormValidation testConnection(String serverUrl, String serverPort, String serverContextPath, boolean useHttpsConnection, String proxyUrl, boolean ignoreSSL) {
        String baseUrl = ATXUtil.getBaseUrl(serverUrl, serverPort, serverContextPath, useHttpsConnection);
        return this.testConnection(baseUrl, proxyUrl, ignoreSSL);
    }

    public FormValidation testConnection(String baseUrl, boolean ignoreSSL) {
        return this.testConnection(baseUrl, "", ignoreSSL);
    }

    public FormValidation testConnection(String baseUrl, String proxyUrl, boolean ignoreSSL) {
        FormValidation returnValue = StringUtils.isBlank((String)baseUrl) ? FormValidation.error((String)Messages.ATXInstallation_InvalidServerUrl(null)) : (baseUrl.contains("$") ? FormValidation.warning((String)Messages.ATXInstallation_NoValidatedConnection()) : this.checkConnection(baseUrl, proxyUrl, ignoreSSL));
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormValidation checkConnection(String baseUrl, String proxyUrl, boolean ignoreSSL) {
        FormValidation returnValue;
        block24: {
            returnValue = FormValidation.okWithMarkup((String)String.format("<span style=\"font-weight: bold; color: #208CA3\">%s</span>", Messages.ATXInstallation_ValidConnection(baseUrl)));
            HttpURLConnection connection = null;
            try {
                String appVersionUrl = String.format("%s/api/app-version-info", baseUrl);
                URL url = new URL(appVersionUrl);
                Proxy proxy = this.configureProxy(proxyUrl);
                if (appVersionUrl.startsWith("https://")) {
                    connection = (HttpsURLConnection)url.openConnection(proxy);
                    if (ignoreSSL) {
                        ATXValidator.ignoreSSLIssues((HttpsURLConnection)connection);
                    }
                } else {
                    connection = (HttpURLConnection)url.openConnection(proxy);
                }
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.setUseCaches(false);
                connection.setRequestMethod("GET");
                connection.connect();
                int httpResponse = connection.getResponseCode();
                if (httpResponse != 200) {
                    returnValue = FormValidation.error((String)Messages.ATXInstallation_ServerNotReachable(baseUrl, "Status code: " + httpResponse));
                    break block24;
                }
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String content = in.readLine();
                    returnValue = Optional.ofNullable(this.parseServerInfo(content, baseUrl)).orElse(returnValue);
                }
            }
            catch (MalformedURLException e) {
                returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidServerUrl(baseUrl));
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                returnValue = FormValidation.error((String)Messages.ATXInstallation_ServerNotReachable(baseUrl, e.getMessage()));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                Authenticator.setDefault(null);
            }
        }
        return returnValue;
    }

    private Proxy configureProxy(String proxyUrl) throws MalformedURLException, UnsupportedEncodingException {
        if (StringUtils.isBlank((String)proxyUrl)) {
            return Proxy.NO_PROXY;
        }
        URL url = new URL(proxyUrl);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort()));
        String userInfo = url.getUserInfo();
        if (StringUtils.isNotBlank((String)userInfo)) {
            String password;
            String userName;
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                userName = URLDecoder.decode(userInfo, StandardCharsets.UTF_8.name());
                password = "";
            } else {
                userName = URLDecoder.decode(userInfo.substring(0, delimiter++), StandardCharsets.UTF_8.name());
                password = URLDecoder.decode(userInfo.substring(delimiter), StandardCharsets.UTF_8.name());
            }
            Authenticator.setDefault(new ProxyAuthenticator(userName, password));
        }
        return proxy;
    }

    private FormValidation parseServerInfo(String content, String baseUrl) {
        FormValidation returnValue = null;
        JSONObject jsonObject = (JSONObject)new JsonSlurper().parseText(content);
        if (jsonObject != null) {
            JSONObject info = jsonObject.optJSONObject("info");
            if (info != null) {
                String license = info.getString("license");
                if (!license.contains("TraceTronic")) {
                    returnValue = FormValidation.warning((String)Messages.ATXInstallation_InvalidServer(baseUrl));
                } else {
                    String version = info.getString("version");
                    ToolVersion atxVersion = ToolVersion.parse(version);
                    if (atxVersion.compareWithoutQualifierTo(ETPlugin.ATX_MIN_VERSION) < 0) {
                        returnValue = FormValidation.warning((String)Messages.ATXInstallation_IncompatibleVersion(version, ETPlugin.ATX_MIN_VERSION.toMicroString()));
                    }
                }
            }
        } else {
            returnValue = FormValidation.error((String)Messages.ATXInstallation_InvalidServer(baseUrl));
        }
        return returnValue;
    }

    private static final class ProxyAuthenticator
    extends Authenticator {
        private final String userName;
        private final String password;

        private ProxyAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

