/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ToolVersion
implements Comparable<ToolVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public ToolVersion(int major, int minor, String qualifier) {
        this(major, minor, 0, qualifier);
    }

    public ToolVersion(int major, int minor, int micro) {
        this(major, minor, micro, "");
    }

    public ToolVersion(int major, int minor, int micro, String qualifier) {
        if (major < 0 || minor < 0 || micro < 0) {
            throw new IllegalArgumentException("Versions must be greater than or equal to 0");
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public static ToolVersion parse(String version) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:[.#](.*))?$");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find() || matcher.groupCount() != 4) {
            throw new IllegalArgumentException("Version must be in form <major>.<minor>[.<micro>][.<qualifier>]");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int micro = 0;
        if (matcher.group(3) != null) {
            micro = Integer.parseInt(matcher.group(3));
        }
        String qualifier = "";
        if (matcher.group(4) != null) {
            qualifier = matcher.group(4);
        }
        return new ToolVersion(major, minor, micro, qualifier);
    }

    @Override
    public int compareTo(ToolVersion version) {
        if (this.major != version.major) {
            return Integer.compare(this.major, version.major);
        }
        if (this.minor != version.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        if (this.micro != version.micro) {
            return Integer.compare(this.micro, version.micro);
        }
        if (this.qualifier != null) {
            if (version.qualifier == null) {
                return 1;
            }
            return this.qualifier.compareTo(version.qualifier);
        }
        if (version.qualifier != null) {
            return -1;
        }
        return 0;
    }

    public int compareWithoutMicroTo(ToolVersion version) {
        if (this.major != version.major) {
            return Integer.compare(this.major, version.major);
        }
        if (this.minor != version.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        return 0;
    }

    public int compareWithoutQualifierTo(ToolVersion version) {
        if (this.major != version.major) {
            return Integer.compare(this.major, version.major);
        }
        if (this.minor != version.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        if (this.micro != version.micro) {
            return Integer.compare(this.micro, version.micro);
        }
        return 0;
    }

    public String toString() {
        return String.format("%d.%d.%d.%s", this.major, this.minor, this.micro, this.qualifier);
    }

    public String toMicroString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.micro);
    }

    public String toMinorString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ToolVersion) {
            ToolVersion that = (ToolVersion)other;
            result = this.compareTo(that) == 0;
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.major).append(this.minor).append(this.micro).append((Object)this.qualifier).toHashCode();
    }
}

