/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util;

import hudson.FilePath;
import hudson.util.IOUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PathUtil {
    private static final Logger LOGGER = Logger.getLogger(PathUtil.class.getName());

    private PathUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String makeAbsolutePath(String path, FilePath relativeTo) {
        if (!IOUtils.isAbsolute((String)path)) {
            FilePath wsDir = new FilePath(relativeTo, path);
            return wsDir.getRemote();
        }
        return path;
    }

    public static boolean copyRemoteFile(FilePath src, FilePath dest) throws IOException, InterruptedException {
        if (dest != null && !dest.exists()) {
            if (src != null && src.exists()) {
                try {
                    LOGGER.log(Level.INFO, String.format("Copy %s to %s", src.getRemote(), dest.getRemote()));
                    src.copyTo(dest);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    return false;
                }
            } else {
                LOGGER.log(Level.SEVERE, String.format("Source %s does not exist!", src != null ? src.getRemote() : ""));
                return false;
            }
        }
        return true;
    }
}

