/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util;

import com.jacob.com.LibraryLoader;
import de.tracetronic.jenkins.plugins.ecutest.util.PathUtil;
import hudson.FilePath;
import hudson.PluginWrapper;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public final class DllUtil {
    private static final Logger LOGGER = Logger.getLogger(DllUtil.class.getName());
    private static final String JACOB_DLL_X86 = "jacob-1.20-x86.dll";
    private static final String JACOB_DLL_X64 = "jacob-1.20-x64.dll";

    private DllUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean loadLibrary(@CheckForNull Computer computer) throws IOException, InterruptedException {
        if (computer == null) {
            return false;
        }
        FilePath libPath = DllUtil.getJacobLibrary(computer);
        return (Boolean)libPath.act((FilePath.FileCallable)new LoadLibraryCallable());
    }

    private static FilePath getJacobLibrary(Computer computer) throws IOException, InterruptedException {
        FilePath jacobLib;
        if (computer instanceof Jenkins.MasterComputer) {
            jacobLib = DllUtil.getLocalLibrary(computer);
        } else {
            jacobLib = DllUtil.getRemoteLibrary(computer);
            FilePath localLib = DllUtil.getLocalLibrary(computer);
            if (!DllUtil.copyLibrary(localLib, jacobLib)) {
                throw new IOException("Could not copy JACOB library to Jenkins agent!");
            }
        }
        return jacobLib;
    }

    private static FilePath getLocalLibrary(Computer computer) throws IOException, InterruptedException {
        FilePath localLib = null;
        String libFile = DllUtil.getLibraryFile(computer);
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return new FilePath((VirtualChannel)FilePath.localChannel, libFile);
        }
        File rootDir = instance.getRootDir();
        PluginWrapper wrapper = instance.getPluginManager().getPlugin("ecutest");
        if (wrapper != null) {
            localLib = new FilePath((VirtualChannel)FilePath.localChannel, rootDir.getAbsolutePath() + "/plugins/" + wrapper.getShortName() + "/WEB-INF/lib/" + libFile);
        }
        return localLib;
    }

    private static FilePath getRemoteLibrary(Computer computer) throws IOException, InterruptedException {
        FilePath rootPath;
        FilePath remoteLib = null;
        String libFile = DllUtil.getLibraryFile(computer);
        Node node = computer.getNode();
        if (node != null && (rootPath = node.getRootPath()) != null) {
            remoteLib = rootPath.child("lib/" + libFile);
        }
        return remoteLib;
    }

    public static String getLibraryFile(Computer computer) throws IOException, InterruptedException {
        return "amd64".equals(computer.getSystemProperties().get("os.arch")) ? JACOB_DLL_X64 : JACOB_DLL_X86;
    }

    private static boolean copyLibrary(FilePath src, FilePath dest) throws IOException, InterruptedException {
        return PathUtil.copyRemoteFile(src, dest);
    }

    private static final class LoadLibraryCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        LoadLibraryCallable() {
        }

        public Boolean invoke(File libFile, VirtualChannel channel) {
            if (libFile.exists() && libFile.isFile()) {
                String libProperty = System.getProperty("jacob.dll.path");
                if (!StringUtils.isBlank((String)libProperty)) {
                    LOGGER.log(Level.FINE, String.format("%s already loaded.", libFile));
                } else {
                    System.setProperty("jacob.dll.path", libFile.getAbsolutePath());
                    try {
                        LibraryLoader.loadJacobLibrary();
                    }
                    catch (UnsatisfiedLinkError e) {
                        LOGGER.log(Level.SEVERE, String.format("Loading local library %s failed: %s", libFile, e.getMessage()));
                        return false;
                    }
                }
            } else {
                LOGGER.log(Level.SEVERE, String.format("Local library %s does not exist!", libFile));
                return false;
            }
            return true;
        }
    }
}

