/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.util;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import hudson.EnvVars;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public final class ATXUtil {
    private ATXUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String getValidATXName(String testName) {
        String validATXName = "DefaultTestName";
        if (testName != null && StringUtils.countMatches((String)testName, (String)"_") != testName.length()) {
            validATXName = testName;
            HashMap<String, String> specialCharMap = new HashMap<String, String>();
            specialCharMap.put("\u00e4", "ae");
            specialCharMap.put("\u00c4", "Ae");
            specialCharMap.put("\u00f6", "oe");
            specialCharMap.put("\u00d6", "Oe");
            specialCharMap.put("\u00fc", "ue");
            specialCharMap.put("\u00dc", "Ue");
            specialCharMap.put("\u00df", "ss");
            specialCharMap.put("-", "_");
            specialCharMap.put("\\.", "_");
            specialCharMap.put(" ", "");
            for (Map.Entry specialChar : specialCharMap.entrySet()) {
                validATXName = validATXName.replaceAll((String)specialChar.getKey(), (String)specialChar.getValue());
            }
            if (Character.isDigit((validATXName = ATXUtil.removeCoherentUnderscores(validATXName)).charAt(0))) {
                validATXName = String.format("i%s", validATXName);
            }
        }
        return validATXName;
    }

    private static String removeCoherentUnderscores(String testName) {
        String validATXName = testName.replace("__", "_");
        if (validATXName.equals(testName)) {
            return validATXName;
        }
        return ATXUtil.removeCoherentUnderscores(validATXName);
    }

    @CheckForNull
    public static String getBaseUrl(ATXConfig config, EnvVars envVars) {
        String fullServerUrl = null;
        if (config != null && envVars != null) {
            List<ATXSetting<?>> uploadSettings = config.getSettingsByGroup(ATXSetting.SettingsGroup.CONNECTION);
            Object useHttpsConnection = config.getSettingValueBySettings("useHttpsConnection", uploadSettings);
            String serverUrl = envVars.expand((String)config.getSettingValueBySettings("serverURL", uploadSettings));
            String serverPort = envVars.expand((String)config.getSettingValueBySettings("serverPort", uploadSettings));
            String contextPath = envVars.expand((String)config.getSettingValueBySettings("serverContextPath", uploadSettings));
            if (serverUrl != null && serverPort != null && contextPath != null && useHttpsConnection != null) {
                fullServerUrl = ATXUtil.getBaseUrl(serverUrl, serverPort, contextPath, (Boolean)useHttpsConnection);
            }
        }
        return fullServerUrl;
    }

    public static String getBaseUrl(String serverUrl, String serverPort, String contextPath, boolean useHttpsConnection) {
        String fullServerUrl = null;
        if (serverUrl != null && serverPort != null && contextPath != null) {
            String protocol = useHttpsConnection ? "https" : "http";
            fullServerUrl = contextPath.isEmpty() ? String.format("%s://%s:%s", protocol, serverUrl, serverPort) : String.format("%s://%s:%s/%s", protocol, serverUrl, serverPort, contextPath);
        }
        return fullServerUrl;
    }

    @CheckForNull
    public static String getProxyUrl(ATXConfig config, EnvVars envVars) {
        String proxyUrl = null;
        if (config != null && envVars != null) {
            List<ATXSetting<?>> uploadSettings = config.getSettingsByGroup(ATXSetting.SettingsGroup.CONNECTION);
            Object useHttpsConnection = config.getSettingValueBySettings("useHttpsConnection", uploadSettings);
            proxyUrl = useHttpsConnection != null && (Boolean)useHttpsConnection != false ? envVars.expand((String)config.getSettingValueBySettings("httpsProxy", uploadSettings)) : envVars.expand((String)config.getSettingValueBySettings("httpProxy", uploadSettings));
        }
        return proxyUrl;
    }

    public static String getProjectId(ATXConfig config, EnvVars envVars) {
        List<ATXSetting<?>> uploadSettings;
        Object projectIdSetting;
        String projectId = null;
        if (config != null && envVars != null && (projectIdSetting = config.getSettingValueBySettings("projectId", uploadSettings = config.getSettingsByGroup(ATXSetting.SettingsGroup.CONNECTION))) != null) {
            projectId = envVars.expand((String)projectIdSetting);
        }
        return projectId;
    }

    public static boolean isSingleTestplanMap(ATXConfig config) {
        List<ATXSetting<?>> specialSettings;
        Object settingValue;
        boolean isMapEnabled = true;
        if (config != null && (settingValue = config.getSettingValueBySettings("mapSeparateProjectExecutionAsSingleTestplan", specialSettings = config.getSettingsByGroup(ATXSetting.SettingsGroup.SPECIAL))) != null) {
            isMapEnabled = (Boolean)settingValue;
        }
        return isMapEnabled;
    }
}

