/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.pipeline;

import com.google.common.collect.Maps;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETToolProperty;
import de.tracetronic.jenkins.plugins.ecutest.tool.pipeline.ETInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public class ETPipeline
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_TOOL_NAME = "toolName";
    private static final String KEY_INSTALL_PATH = "installPath";
    private static final String KEY_PROPERTY = "property";
    private final CpsScript script;

    public ETPipeline(CpsScript script) {
        this.script = script;
    }

    @Whitelisted
    public ETInstance installation(String toolName) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, toolName);
        ETInstance installation = (ETInstance)this.script.invokeMethod("getETInstallation", (Object)stepVariables);
        installation.setScript(this.script);
        return installation;
    }

    @Whitelisted
    public ETInstance installation(Map<String, Object> installArgs) {
        List<String> keysAsList = Collections.singletonList(KEY_TOOL_NAME);
        if (!keysAsList.containsAll(installArgs.keySet())) {
            throw new IllegalArgumentException("The installation method requires the following arguments at least: " + keysAsList);
        }
        ETInstance installation = (ETInstance)this.script.invokeMethod("getETInstallation", installArgs);
        installation.setScript(this.script);
        return installation;
    }

    @Whitelisted
    public ETInstance newInstallation(String toolName, String installPath) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, toolName);
        stepVariables.put(KEY_INSTALL_PATH, installPath);
        ETInstance server = (ETInstance)this.script.invokeMethod("newETInstallation", (Object)stepVariables);
        server.setScript(this.script);
        return server;
    }

    @Whitelisted
    public ETInstance newInstallation(String toolName, String installPath, String progId, int timeout, boolean registerComServer) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, toolName);
        stepVariables.put(KEY_INSTALL_PATH, installPath);
        ETToolProperty property = new ETToolProperty(progId, timeout, registerComServer);
        stepVariables.put(KEY_PROPERTY, property);
        ETInstance installation = (ETInstance)this.script.invokeMethod("newETInstallation", (Object)stepVariables);
        installation.setScript(this.script);
        return installation;
    }

    @Whitelisted
    public ETInstance newInstallation(Map<String, Object> installArgs) {
        ArrayList<String> requiredKeys = new ArrayList<String>(Arrays.asList(KEY_TOOL_NAME, KEY_INSTALL_PATH));
        if (!installArgs.keySet().containsAll(requiredKeys)) {
            throw new IllegalArgumentException("The newInstallation method requires the following arguments at least: " + requiredKeys);
        }
        if (installArgs.containsKey(KEY_PROPERTY) && installArgs.get(KEY_PROPERTY) instanceof ETToolProperty) {
            ETToolProperty property = (ETToolProperty)installArgs.get(KEY_PROPERTY);
            return this.newInstallation((String)installArgs.get(KEY_TOOL_NAME), (String)installArgs.get(KEY_INSTALL_PATH), property.getProgId(), property.getTimeout(), property.isRegisterComServer());
        }
        requiredKeys.addAll(Arrays.asList("progId", "timeout", "registerComServer"));
        if (installArgs.keySet().containsAll(requiredKeys)) {
            return this.newInstallation(installArgs.get(KEY_TOOL_NAME).toString(), installArgs.get(KEY_INSTALL_PATH).toString(), installArgs.get("progId").toString(), (Integer)installArgs.get("timeout"), (Boolean)installArgs.get("registerComServer"));
        }
        return this.newInstallation(installArgs.get(KEY_TOOL_NAME).toString(), installArgs.get(KEY_INSTALL_PATH).toString());
    }
}

