/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.pipeline;

import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETToolProperty;
import de.tracetronic.jenkins.plugins.ecutest.tool.pipeline.ETInstance;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ETNewInstallationStep
extends Step {
    @Nonnull
    private final String toolName;
    @Nonnull
    private final String installPath;
    @CheckForNull
    private final ETToolProperty property;

    @DataBoundConstructor
    public ETNewInstallationStep(@Nonnull String toolName, @Nonnull String installPath, ETToolProperty property) {
        this.toolName = toolName;
        this.installPath = installPath;
        this.property = property != null ? property : new ETToolProperty(null, 0, false);
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    @Nonnull
    public String getInstallPath() {
        return this.installPath;
    }

    @CheckForNull
    public ETToolProperty getProperty() {
        return this.property;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "newETInstallation";
        }

        public String getDisplayName() {
            return "Return new ECU-TEST installation";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }
    }

    private static class Execution
    extends SynchronousStepExecution<ETInstance> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ETNewInstallationStep step;

        Execution(ETNewInstallationStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected ETInstance run() {
            ETInstallation installation = new ETInstallation(this.step.toolName, this.step.installPath, Collections.singletonList(this.step.property));
            return new ETInstance(installation);
        }
    }
}

