/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.pipeline;

import com.google.common.collect.Maps;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.tms.TMSPublisher;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public class ETInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_TOOL_NAME = "toolName";
    private static final String KEY_INSTALLATION = "installation";
    private static final String KEY_TIMEOUT = "timeout";
    @Nonnull
    private final ETInstallation installation;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient CpsScript script;

    public ETInstance(@Nonnull ETInstallation installation) {
        this.installation = installation;
    }

    @Nonnull
    @Whitelisted
    public ETInstallation getInstallation() {
        return this.installation;
    }

    public void setScript(CpsScript script) {
        this.script = script;
    }

    @Whitelisted
    public void start() {
        this.start("", "", 120, false, false, false);
    }

    @Whitelisted
    public void start(String workspaceDir, String settingsDir) {
        this.start(workspaceDir, settingsDir, 120, false, false, false);
    }

    @Whitelisted
    public void start(String workspaceDir, String settingsDir, int timeout, boolean debugMode, boolean keepInstance, boolean updateUserLibs) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        stepVariables.put("workspaceDir", workspaceDir);
        stepVariables.put("settingsDir", settingsDir);
        stepVariables.put("debugMode", debugMode);
        stepVariables.put("keepInstance", keepInstance);
        stepVariables.put("updateUserLibs", updateUserLibs);
        this.script.invokeMethod("startET", (Object)stepVariables);
    }

    @Whitelisted
    public void start(Map<String, Object> settings) {
        this.invokeMethod("startET", settings);
    }

    @Whitelisted
    public void stop() {
        this.stop(30);
    }

    @Whitelisted
    public void stop(int timeout) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        this.script.invokeMethod("stopET", (Object)stepVariables);
    }

    @Whitelisted
    public void stop(Map<String, Object> settings) {
        this.invokeMethod("stopET", settings);
    }

    @Whitelisted
    public void startTS() {
        this.startTS("", 5017, 120, false);
    }

    @Whitelisted
    public void startTS(String toolLibsIniPath, int tcpPort, int timeout, boolean keepInstance) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        stepVariables.put("toolLibsIniPath", toolLibsIniPath);
        stepVariables.put("tcpPort", tcpPort);
        stepVariables.put("keepInstance", keepInstance);
        this.script.invokeMethod("startTS", (Object)stepVariables);
    }

    @Whitelisted
    public void startTS(Map<String, Object> settings) {
        this.invokeMethod("startTS", settings);
    }

    @Whitelisted
    public void stopTS() {
        this.stop(30);
    }

    @Whitelisted
    public void stopTS(int timeout) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        this.script.invokeMethod("stopTS", (Object)stepVariables);
    }

    @Whitelisted
    public void stopTS(Map<String, Object> settings) {
        this.invokeMethod("stopTS", settings);
    }

    @Whitelisted
    public void publishUNIT() {
        this.publishUNIT(0.0, 0.0, false, false);
    }

    @Whitelisted
    public void publishUNIT(double unstableThreshold, double failedThreshold, boolean allowMissing, boolean runOnFailed) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put("unstableThreshold", unstableThreshold);
        stepVariables.put("failedThreshold", failedThreshold);
        stepVariables.put("allowMissing", allowMissing);
        stepVariables.put("runOnFailed", runOnFailed);
        this.script.invokeMethod("publishUNIT", (Object)stepVariables);
    }

    @Whitelisted
    public void publishUNIT(Map<String, Object> settings) {
        this.invokeMethod("publishUNIT", settings);
    }

    @Whitelisted
    public void publishGenerators(List<ReportGeneratorConfig> generators, List<ReportGeneratorConfig> customGenerators) {
        this.publishGenerators(generators, customGenerators, false, false, true, true);
    }

    @Whitelisted
    public void publishGenerators(List<ReportGeneratorConfig> generators, List<ReportGeneratorConfig> customGenerators, boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put("generators", generators);
        stepVariables.put("customGenerators", customGenerators);
        stepVariables.put("allowMissing", allowMissing);
        stepVariables.put("runOnFailed", runOnFailed);
        stepVariables.put("archiving", archiving);
        stepVariables.put("keepAll", keepAll);
        this.script.invokeMethod("publishGenerators", (Object)stepVariables);
    }

    @Whitelisted
    public void publishGenerators(Map<String, Object> settings) {
        this.invokeMethod("publishGenerators", settings);
    }

    @Whitelisted
    public void publishTMS(String credentialsId) {
        this.publishTMS(credentialsId, TMSPublisher.getDefaultTimeout(), false, false, true, true);
    }

    @Whitelisted
    public void publishTMS(String credentialsId, int timeout, boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        stepVariables.put("credentialsId", credentialsId);
        stepVariables.put("allowMissing", allowMissing);
        stepVariables.put("runOnFailed", runOnFailed);
        stepVariables.put("archiving", archiving);
        stepVariables.put("keepAll", keepAll);
        this.script.invokeMethod("publishTMS", (Object)stepVariables);
    }

    @Whitelisted
    public void publishTMS(Map<String, Object> settings) {
        this.invokeMethod("publishTMS", settings);
    }

    @Whitelisted
    public void publishTraceAnalysis() {
        this.publishTraceAnalysis(true, false, TraceAnalysisPublisher.getDefaultTimeout(), false, false, true, true);
    }

    @Whitelisted
    public void publishTraceAnalysis(boolean mergeReports, boolean createReportDir, int timeout, boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.put(KEY_TIMEOUT, String.valueOf(timeout));
        stepVariables.put("mergeReports", mergeReports);
        stepVariables.put("createReportDir", createReportDir);
        stepVariables.put("allowMissing", allowMissing);
        stepVariables.put("runOnFailed", runOnFailed);
        stepVariables.put("archiving", archiving);
        stepVariables.put("keepAll", keepAll);
        this.script.invokeMethod("publishTraceAnalysis", (Object)stepVariables);
    }

    @Whitelisted
    public void publishTraceAnalysis(Map<String, Object> settings) {
        this.invokeMethod("publishTraceAnalysis", settings);
    }

    @Whitelisted
    public boolean isConfigStarted() {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        return (Boolean)this.script.invokeMethod("isConfigStarted", (Object)stepVariables);
    }

    private void invokeMethod(String name, Map<String, Object> settings) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_TOOL_NAME, this.installation.getName());
        stepVariables.put(KEY_INSTALLATION, this.installation);
        stepVariables.putAll(settings);
        this.script.invokeMethod(name, (Object)stepVariables);
    }
}

