/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.pipeline;

import com.google.common.collect.ImmutableSet;
import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.tool.pipeline.ETInstance;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.TaskListener;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ETGetInstallationStep
extends Step {
    private final String toolName;

    @DataBoundConstructor
    public ETGetInstallationStep(String toolName) {
        this.toolName = toolName;
    }

    public String getToolName() {
        return this.toolName;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getETInstallation";
        }

        public String getDisplayName() {
            return "Get ECU-TEST installation by name";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }
    }

    private static class Execution
    extends SynchronousStepExecution<ETInstance> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ETGetInstallationStep step;

        Execution(ETGetInstallationStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected ETInstance run() throws Exception {
            ETInstallation installation = ETInstallation.get(this.step.toolName);
            if (installation == null) {
                TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
                String message = String.format("ECU-TEST installation with name '%s' is not configured!", this.step.toolName);
                throw new ETPluginException(message, listener);
            }
            return new ETInstance(installation);
        }
    }
}

