/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.pipeline;

import com.google.common.collect.ImmutableSet;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ETConfigStartedStep
extends Step {
    private final String toolName;

    @DataBoundConstructor
    public ETConfigStartedStep(String toolName) {
        this.toolName = toolName;
    }

    public String getToolName() {
        return this.toolName;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "isConfigStarted";
        }

        public String getDisplayName() {
            return "Check ECU-TEST configuration status";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Launcher.class, TaskListener.class);
        }
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ETConfigStartedStep step;

        Execution(ETConfigStartedStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Boolean run() throws Exception {
            ETClient client = new ETClient(this.step.toolName, 0);
            return client.checkConfigStatus((Launcher)Objects.requireNonNull(this.getContext().get(Launcher.class)), (TaskListener)this.getContext().get(TaskListener.class));
        }
    }
}

