/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.installation;

import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.Messages;
import hudson.Extension;
import hudson.tools.ToolProperty;
import hudson.tools.ToolPropertyDescriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ETToolProperty
extends ToolProperty<ETInstallation>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String progId;
    private final int timeout;
    private final boolean registerComServer;

    @DataBoundConstructor
    public ETToolProperty(String progId, int timeout, boolean registerComServer) {
        this.progId = StringUtils.defaultIfBlank((String)progId, (String)"ECU-TEST.Application");
        this.timeout = timeout;
        this.registerComServer = registerComServer;
    }

    public String getProgId() {
        return this.progId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isRegisterComServer() {
        return this.registerComServer;
    }

    public Class<ETInstallation> type() {
        return ETInstallation.class;
    }

    @Symbol(value={"ecuTestProperty"})
    @Extension
    public static final class DescriptorImpl
    extends ToolPropertyDescriptor {
        public DescriptorImpl() {
            super(ETToolProperty.class);
            this.load();
        }

        public static String getDefaultProgId() {
            return "ECU-TEST.Application";
        }

        public static int getDefaultTimeout() {
            return 0;
        }

        public FormValidation doCheckProgId(@QueryParameter String value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            FormValidation returnValue = FormValidation.ok();
            if (!StringUtils.isEmpty((String)value)) {
                String pattern = "^(ECU-TEST\\.Application(\\.\\d+.\\d+)?|ECU-TEST6?\\.Application)";
                if (!Pattern.matches("^(ECU-TEST\\.Application(\\.\\d+.\\d+)?|ECU-TEST6?\\.Application)", value)) {
                    returnValue = FormValidation.error((String)Messages.ETToolProperty_InvalidProgID(value));
                }
            }
            return returnValue;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.save();
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ETToolProperty_DisplayName();
        }
    }
}

