/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.installation;

import com.thoughtworks.xstream.XStream;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.junit.JUnitPublisher;
import de.tracetronic.jenkins.plugins.ecutest.tool.StartETBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StartTSBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StopETBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.StopTSBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.AbstractToolInstallation;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETToolProperty;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.Messages;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ETInstallation
extends AbstractToolInstallation {
    private static final long serialVersionUID = 1L;
    private static final String EXECUTABLE = "ECU-TEST.exe";
    private static final String COM_EXECUTABLE = "ECU-TEST_COM.exe";
    private static final String TS_EXECUTABLE = "Tool-Server.exe";

    @DataBoundConstructor
    public ETInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public ETInstallation(ETInstallation source, String home, List<? extends ToolProperty<?>> properties) {
        super(source.getName(), home, properties);
    }

    public ETInstallation forEnvironment(EnvVars env) {
        return new ETInstallation(this, env.expand(this.getHome()), this.getProperties().toList());
    }

    public ETInstallation forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new ETInstallation(this, this.translateFor(node, log), this.getProperties().toList());
    }

    @Override
    protected File getExeFile(File home) {
        return DescriptorImpl.getExeFile(home);
    }

    public String getComExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new GetComExecutableCallable(this.getHome()));
    }

    public String getTSExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new GetTSExecutableCallable(this.getHome()));
    }

    public String getProgId() {
        ETToolProperty toolProperty = (ETToolProperty)this.getProperties().get(ETToolProperty.class);
        String progId = toolProperty != null ? toolProperty.getProgId() : ETToolProperty.DescriptorImpl.getDefaultProgId();
        return progId;
    }

    public int getTimeout() {
        ETToolProperty toolProperty = (ETToolProperty)this.getProperties().get(ETToolProperty.class);
        int timeout = toolProperty != null ? toolProperty.getTimeout() : ETToolProperty.DescriptorImpl.getDefaultTimeout();
        return timeout;
    }

    public boolean isRegisterComServer() {
        ETToolProperty toolProperty = (ETToolProperty)this.getProperties().get(ETToolProperty.class);
        return toolProperty != null && toolProperty.isRegisterComServer();
    }

    public static ETInstallation[] installs() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return new ETInstallation[0];
        }
        DescriptorImpl etDescriptor = (DescriptorImpl)instance.getDescriptorByType(DescriptorImpl.class);
        return etDescriptor.getInstallations();
    }

    @CheckForNull
    public static ETInstallation get(String name) {
        ETInstallation[] installations;
        for (ETInstallation installation : installations = ETInstallation.installs()) {
            if (!StringUtils.equals((String)name, (String)installation.getName())) continue;
            return installation;
        }
        return null;
    }

    @Symbol(value={"ecuTest"})
    @Extension(ordinal=1001.0)
    public static class DescriptorImpl
    extends ToolDescriptor<ETInstallation> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
        private volatile ETInstallation[] installations = new ETInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        @CheckForNull
        private static File getExeFile(File home) {
            if (Functions.isWindows() && home != null) {
                return new File(home, ETInstallation.EXECUTABLE);
            }
            return null;
        }

        @CheckForNull
        private static File getComExeFile(File home) {
            if (Functions.isWindows() && home != null) {
                return new File(home, ETInstallation.COM_EXECUTABLE);
            }
            return null;
        }

        @CheckForNull
        private static File getTSExeFile(File home, String subDir) {
            if (Functions.isWindows() && home != null && subDir != null) {
                return new File(new File(home, subDir), ETInstallation.TS_EXECUTABLE);
            }
            return null;
        }

        public synchronized void load() {
            if (this.getConfigFile().exists()) {
                super.load();
            } else {
                this.migrateFromOldConfigFile(StartETBuilder.DescriptorImpl.class);
                this.migrateFromOldConfigFile(StopETBuilder.DescriptorImpl.class);
                this.migrateFromOldConfigFile(StartTSBuilder.DescriptorImpl.class);
                this.migrateFromOldConfigFile(StopTSBuilder.DescriptorImpl.class);
                this.migrateFromOldConfigFile(JUnitPublisher.DescriptorImpl.class);
                this.migrateFromOldConfigFile(ReportGeneratorPublisher.DescriptorImpl.class);
                this.save();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateFromOldConfigFile(Class oldClass) {
            LOGGER.log(Level.FINE, "Migrating ECU-TEST installations from: " + oldClass.getName());
            XStream2 stream = new XStream2();
            stream.addCompatibilityAlias(oldClass.getName(), ((Object)((Object)this)).getClass());
            XmlFile file = new XmlFile((XStream)stream, new File(Jenkins.getInstance().getRootDir(), oldClass.getEnclosingClass().getName() + ".xml"));
            if (file.exists()) {
                try {
                    file.unmarshal((Object)this);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to migrate ECU-TEST installations from: " + file, e);
                }
                finally {
                    file.delete();
                }
            }
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ETInstallation_DisplayName();
        }

        public ETInstallation[] getInstallations() {
            return (ETInstallation[])this.installations.clone();
        }

        public void setInstallations(ETInstallation ... installations) {
            ArrayList inst = new ArrayList();
            if (installations != null) {
                Collections.addAll(inst, installations);
                for (ETInstallation installation : installations) {
                    if (!StringUtils.isBlank((String)installation.getName())) continue;
                    inst.remove((Object)installation);
                }
            }
            this.installations = inst.toArray(new ETInstallation[0]);
            this.save();
        }

        @CheckForNull
        public ETInstallation getInstallation(String name) {
            for (ETInstallation installation : this.getInstallations()) {
                if (!installation.getName().equals(name)) continue;
                return installation;
            }
            return null;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            FormValidation returnValue = FormValidation.ok();
            if (!Functions.isWindows()) {
                returnValue = FormValidation.warning((String)Messages.ETInstallation_IsUnixSystem());
            } else if (StringUtils.isNotEmpty((String)value.toString())) {
                if (value.isDirectory()) {
                    File etExe = DescriptorImpl.getExeFile(value);
                    if (etExe == null || !etExe.exists()) {
                        returnValue = FormValidation.error((String)Messages.ETInstallation_NotHomeDirectory(value));
                    }
                } else {
                    returnValue = FormValidation.error((String)Messages.ETInstallation_NotADirectory(value));
                }
            } else {
                returnValue = FormValidation.warning((String)Messages.ETInstallation_NotRequired());
            }
            return returnValue;
        }
    }

    private static final class GetTSExecutableCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String home;

        GetTSExecutableCallable(String home) {
            this.home = home;
        }

        public String call() {
            File exe = this.getTSExeFile("");
            if (exe == null || !exe.exists()) {
                exe = this.getTSExeFile("ToolServer");
            }
            return exe != null && exe.exists() ? exe.getPath() : null;
        }

        @CheckForNull
        private File getTSExeFile(String subDir) {
            String expHome;
            if (this.home != null && (expHome = Util.replaceMacro((String)this.home, (Map)EnvVars.masterEnvVars)) != null) {
                return DescriptorImpl.getTSExeFile(new File(expHome), subDir);
            }
            return null;
        }
    }

    private static final class GetComExecutableCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String home;

        GetComExecutableCallable(String home) {
            this.home = home;
        }

        public String call() {
            File exe = this.getComExeFile(this.home);
            return exe != null && exe.exists() ? exe.getPath() : null;
        }

        @CheckForNull
        private File getComExeFile(String home) {
            String expHome;
            if (home != null && (expHome = Util.replaceMacro((String)home, (Map)EnvVars.masterEnvVars)) != null) {
                return DescriptorImpl.getComExeFile(new File(expHome));
            }
            return null;
        }
    }
}

