/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.client;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Cache;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Caches;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;

public class CacheClient {
    private static final ToolVersion ET_MIN_VERSION = new ToolVersion(7, 2, 0);
    private final Caches.CacheType type;
    private final String filePath;
    private final String dbChannel;
    private final boolean clear;

    public CacheClient(Caches.CacheType type, String filePath, String dbChannel, boolean clear) {
        this.type = type;
        this.filePath = filePath;
        this.dbChannel = dbChannel;
        this.clear = clear;
    }

    public Caches.CacheType getType() {
        return this.type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDbChannel() {
        return this.dbChannel;
    }

    public boolean isClear() {
        return this.clear;
    }

    public void generateCache(Launcher launcher, TaskListener listener) throws IOException, InterruptedException, ETPluginException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(String.format("Generating %s cache...", this.type.name()));
        if (!((Boolean)launcher.getChannel().call((Callable)new GenerateCacheCallable(this.type, this.filePath, this.dbChannel, this.clear, listener))).booleanValue()) {
            throw new ETPluginException(String.format("Generating %s cache failed!", this.type.name()));
        }
        logger.logInfo(String.format("%s cache generated successfully.", this.type.name()));
    }

    public static boolean isCompatible(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!CacheClient.checkETInstance(launcher, listener)) {
            logger.logError("No running ECU-TEST instance found, please configure one at first!");
            return false;
        }
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        return (Boolean)launcher.getChannel().call((Callable)new CompatibleCacheCallable(ET_MIN_VERSION, listener));
    }

    private static boolean checkETInstance(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> foundProcesses = ETClient.checkProcesses(launcher, listener, false);
        return !foundProcesses.isEmpty();
    }

    private static final class CompatibleCacheCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final ToolVersion minVersion;

        CompatibleCacheCallable(ToolVersion minVersion, TaskListener listener) {
            this.listener = listener;
            this.minVersion = minVersion;
        }

        public Boolean call() throws IOException {
            boolean isAvailable = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                String comVersion = comClient.getVersion();
                ToolVersion comToolVersion = ToolVersion.parse(comVersion);
                if (comToolVersion.compareTo(this.minVersion) < 0) {
                    logger.logError(String.format("The configured ECU-TEST version %s does not support the cache module. Please use at least ECU-TEST %s!", comVersion, this.minVersion.toMicroString()));
                }
                comClient.getCaches();
                isAvailable = true;
            }
            catch (ETComException e) {
                logger.logError(String.format("The cache module is not available in running ECU-TEST instance! Please use at least ECU-TEST %s!", this.minVersion.toMicroString()));
                logger.logComException(e);
            }
            return isAvailable;
        }
    }

    private static final class GenerateCacheCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final Caches.CacheType type;
        private final String filePath;
        private final String dbChannel;
        private final boolean clear;
        private final TaskListener listener;

        GenerateCacheCallable(Caches.CacheType type, String filePath, String dbChannel, boolean clear, TaskListener listener) {
            this.type = type;
            this.filePath = filePath;
            this.dbChannel = dbChannel;
            this.clear = clear;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient client = new ETComClient(progId);){
                Caches caches = (Caches)client.getCaches();
                Cache cache = caches.getCacheByType(this.type);
                String cacheType = this.type.name();
                if (this.clear) {
                    logger.logInfo(String.format("- Removing all %s cache files...", cacheType));
                    cache.clear(true);
                }
                logger.logInfo(String.format("- Inserting %s to %s cache...", this.filePath, cacheType));
                cache.insert(this.filePath, this.dbChannel);
                List<String> files = cache.getFiles();
                logger.logInfo(String.format("-> Available %s cache files: %s", cacheType, files.toString()));
            }
            catch (ETComException e) {
                logger.logComException(e);
                return false;
            }
            return true;
        }
    }
}

