/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ToolClient;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractToolClient
implements ToolClient {
    private final String toolName;
    private final String installPath;
    private final int timeout;

    public AbstractToolClient(String toolName, String installPath, int timeout) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
        this.installPath = StringUtils.trimToEmpty((String)installPath);
        this.timeout = timeout;
    }

    public AbstractToolClient(String toolName, int timeout) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
        this.timeout = timeout;
        this.installPath = "";
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected abstract ArgumentListBuilder createCmdLine();

    protected boolean launchProcess(Launcher launcher, TaskListener listener) throws InterruptedException {
        ArgumentListBuilder args = this.createCmdLine();
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(args.toString());
        boolean isStarted = false;
        try {
            Proc process = launcher.launch().cmds(args).quiet(true).start();
            long endTimeMillis = System.currentTimeMillis() + (long)this.getTimeout() * 1000L;
            while (this.getTimeout() <= 0 || System.currentTimeMillis() < endTimeMillis) {
                if (process.isAlive()) {
                    isStarted = true;
                    break;
                }
                Thread.sleep(1000L);
            }
            if (!isStarted) {
                logger.logError(String.format("-> Timeout of %d seconds reached! This can also be caused by an invalid  license.", this.getTimeout()));
            }
        }
        catch (IOException e) {
            logger.logError("-> Command line execution failed: " + e.getMessage());
        }
        return isStarted;
    }
}

