/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.TSClient;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class StartTSBuilder
extends AbstractToolBuilder {
    public static final int DEFAULT_TIMEOUT = 120;
    public static final int DEFAULT_TCP_PORT = 5017;
    @CheckForNull
    private String toolLibsIni;
    @Nonnull
    private String tcpPort = String.valueOf(5017);
    private boolean keepInstance;

    @DataBoundConstructor
    public StartTSBuilder(@Nonnull String toolName) {
        super(toolName);
    }

    @Override
    public int getDefaultTimeout() {
        return 120;
    }

    public int getDefaultTcpPort() {
        return 5017;
    }

    @Nonnull
    public String getToolLibsIni() {
        return StringUtils.trimToEmpty((String)this.toolLibsIni);
    }

    @DataBoundSetter
    public void setToolLibsIni(@CheckForNull String toolLibsIni) {
        this.toolLibsIni = Util.fixNull((String)toolLibsIni);
    }

    @Nonnull
    public String getTcpPort() {
        return this.tcpPort;
    }

    @DataBoundSetter
    public void setTcpPort(@CheckForNull String tcpPort) {
        this.tcpPort = StringUtils.defaultIfBlank((String)tcpPort, (String)String.valueOf(this.getDefaultTcpPort()));
    }

    public boolean isKeepInstance() {
        return this.keepInstance;
    }

    @DataBoundSetter
    public void setKeepInstance(boolean keepInstance) {
        this.keepInstance = keepInstance;
    }

    @Override
    public void performTool(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        List<String> foundProcesses = TSClient.checkProcesses(launcher, false);
        if (this.isKeepInstance() && !foundProcesses.isEmpty()) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logInfo("Re-using already running Tool-Server instance...");
        } else {
            EnvVars envVars = run.getEnvironment(listener);
            int expTimeout = Integer.parseInt(EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(120)));
            int expTcpPort = Integer.parseInt(EnvUtil.expandEnvVar(this.getTcpPort(), envVars, String.valueOf(5017)));
            String expToolLibs = envVars.expand(this.getToolLibsIni());
            FilePath expToolLibsPath = new FilePath(launcher.getChannel(), expToolLibs);
            if (!expToolLibsPath.exists()) {
                throw new ETPluginException(String.format("ToolLibs.ini path at %s does not exist!", expToolLibsPath.getRemote()));
            }
            if (!this.isInstallationVerified(envVars)) {
                this.setInstallation(this.configureToolInstallation(workspace.toComputer(), listener, envVars));
            }
            String installPath = this.getInstallation().getTSExecutable(launcher);
            TSClient tsClient = new TSClient(this.getToolName(), installPath, expTimeout, expToolLibs, expTcpPort);
            if (!tsClient.start(true, workspace, launcher, listener)) {
                throw new ETPluginException("Starting Tool-Server failed!");
            }
        }
    }

    @Symbol(value={"startTS"})
    @Extension(ordinal=10009.0)
    public static final class DescriptorImpl
    extends AbstractToolDescriptor {
        @Override
        public int getDefaultTimeout() {
            return 120;
        }

        public int getDefaultTcpPort() {
            return 5017;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.StartTSBuilder_DisplayName();
        }

        public FormValidation doCheckToolLibsIni(@QueryParameter String value) {
            return this.toolValidator.validateToolLibsIni(value);
        }

        public FormValidation doCheckTcpPort(@QueryParameter String value) {
            return this.toolValidator.validateTcpPort(value);
        }
    }
}

