/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class LicenseETBuilder
extends AbstractToolBuilder {
    @DataBoundConstructor
    public LicenseETBuilder(@Nonnull String toolName) {
        super(toolName);
    }

    @Override
    public int getDefaultTimeout() {
        return 0;
    }

    @Override
    public void performTool(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        List<String> foundProcesses = ETClient.checkProcesses(launcher, listener, false);
        if (!foundProcesses.isEmpty()) {
            logger.logInfo("Running ECU-TEST instance found, therefore a license is available...");
        } else {
            EnvVars envVars = run.getEnvironment(listener);
            if (!this.isInstallationVerified(envVars)) {
                this.setInstallation(this.configureToolInstallation(workspace.toComputer(), listener, envVars));
            }
            String installPath = this.getInstallation().getExecutable(launcher);
            String toolName = this.getInstallation().getName();
            if (StringUtils.isEmpty((String)installPath)) {
                throw new ETPluginException(String.format("ECU-TEST executable for '%s' could not be found!", toolName));
            }
            ETClient etClient = new ETClient(toolName, installPath, "", "", this.getDefaultTimeout(), false);
            etClient.setLicenseCheck(true);
            if (!etClient.checkLicense(launcher, listener)) {
                logger.logError(String.format("-> No valid license for '%s' found.", toolName));
                throw new ETPluginException(String.format("License check '%s' failed.", toolName));
            }
            logger.logInfo(String.format("-> Valid license for '%s' found.", toolName));
        }
    }

    @Symbol(value={"checkETLicense"})
    @Extension(ordinal=10012.0)
    public static final class DescriptorImpl
    extends AbstractToolDescriptor {
        @Override
        public int getDefaultTimeout() {
            return 0;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.LicenseETBuilder_DisplayName();
        }
    }
}

