/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ToolValidator;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Caches;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CacheConfig
extends AbstractDescribableImpl<CacheConfig>
implements ExpandableConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Caches.CacheType type;
    private final String filePath;
    private final String dbChannel;
    private final boolean clear;

    @DataBoundConstructor
    public CacheConfig(Caches.CacheType type, String filePath, String dbChannel, boolean clear) {
        this.type = type;
        this.filePath = StringUtils.trimToEmpty((String)filePath);
        this.dbChannel = StringUtils.trimToEmpty((String)dbChannel);
        this.clear = clear;
    }

    public Caches.CacheType getType() {
        return this.type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDbChannel() {
        return this.dbChannel;
    }

    public boolean isClear() {
        return this.clear;
    }

    @Override
    public CacheConfig expand(EnvVars envVars) {
        String expFilePath = envVars.expand(this.getFilePath());
        String expDbChannel = envVars.expand(this.getDbChannel());
        return new CacheConfig(this.getType(), expFilePath, expDbChannel, this.isClear());
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof CacheConfig) {
            CacheConfig that = (CacheConfig)other;
            result = Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.dbChannel, that.dbChannel) && this.clear == that.clear;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.type).append((Object)this.filePath).append((Object)this.dbChannel).append(this.clear).toHashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CacheConfig> {
        private final ToolValidator toolValidator = new ToolValidator();

        public ListBoxModel doFillTypeItems() {
            ListBoxModel model = new ListBoxModel();
            for (Caches.CacheType type : Caches.CacheType.values()) {
                model.add(type.name(), type.name());
            }
            return model;
        }

        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return this.toolValidator.validateRequiredParamValue(value);
        }

        public FormValidation doCheckDbChannel(@QueryParameter String value) {
            return this.toolValidator.validateParameterizedValue(value);
        }

        @Nonnull
        public String getDisplayName() {
            return "Cache Configuration";
        }
    }
}

