/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.tool;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.CacheConfig;
import de.tracetronic.jenkins.plugins.ecutest.tool.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.CacheClient;
import de.tracetronic.jenkins.plugins.ecutest.util.PathUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class CacheBuilder
extends Builder
implements SimpleBuildStep {
    private final List<CacheConfig> caches;

    @DataBoundConstructor
    public CacheBuilder(List<CacheConfig> caches) {
        this.caches = caches == null ? new ArrayList() : CacheBuilder.removeEmptyCaches(caches);
    }

    public List<CacheConfig> getCaches() {
        return this.caches;
    }

    private static List<CacheConfig> removeEmptyCaches(List<CacheConfig> caches) {
        ArrayList<CacheConfig> validCaches = new ArrayList<CacheConfig>();
        for (CacheConfig cache : caches) {
            if (!StringUtils.isNotBlank((String)cache.getFilePath())) continue;
            validCaches.add(cache);
        }
        return validCaches;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            ProcessUtil.checkOS(launcher);
            if (CacheClient.isCompatible(workspace, launcher, listener)) {
                this.performCache(run, workspace, launcher, listener);
            } else {
                run.setResult(Result.FAILURE);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    private void performCache(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException, ETPluginException {
        EnvVars envVars = run.getEnvironment(listener);
        for (CacheConfig cache : this.caches) {
            CacheConfig expCache = cache.expand(envVars);
            String expFilePath = PathUtil.makeAbsolutePath(expCache.getFilePath(), workspace);
            String expDbChannel = PathUtil.makeAbsolutePath(expCache.getDbChannel(), workspace);
            CacheClient client = new CacheClient(expCache.getType(), expFilePath, expDbChannel, expCache.isClear());
            client.generateCache(launcher, listener);
        }
    }

    @Symbol(value={"generateCache"})
    @Extension(ordinal=10007.0)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.CacheBuilder_DisplayName();
        }
    }
}

