/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.scan;

import hudson.Launcher;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tools.ant.DirectoryScanner;

public abstract class AbstractTestScanner {
    private final String inputDir;
    private final boolean recursive;
    private final transient Launcher launcher;

    public AbstractTestScanner(String inputDir, boolean recursive, Launcher launcher) {
        this.inputDir = inputDir;
        this.recursive = recursive;
        this.launcher = launcher;
    }

    public String getInputDir() {
        return this.inputDir;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<String> scanTestFiles() throws IOException, InterruptedException {
        return (List)this.launcher.getChannel().call((Callable)new ScanTestCallable(this.inputDir, this.getFilePattern()));
    }

    protected String getFilePattern() {
        String filePattern = this.isRecursive() ? "**/**" + this.getFileExtension() : "*" + this.getFileExtension();
        return filePattern;
    }

    protected abstract String getFileExtension();

    private static final class ScanTestCallable
    extends MasterToSlaveCallable<List<String>, IOException> {
        private static final long serialVersionUID = 1L;
        private final String inputDir;
        private final String filePattern;

        ScanTestCallable(String inputDir, String filePattern) {
            this.inputDir = inputDir;
            this.filePattern = filePattern;
        }

        public List<String> call() throws IOException {
            String[] fileNames;
            ArrayList<String> includeFiles = new ArrayList<String>();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.inputDir);
            scanner.setIncludes(new String[]{this.filePattern});
            scanner.scan();
            for (String fileName : fileNames = scanner.getIncludedFiles()) {
                includeFiles.add(new File(this.inputDir, fileName).getAbsolutePath());
            }
            return includeFiles;
        }
    }
}

