/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.GlobalConstant;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TestConfig
extends AbstractDescribableImpl<TestConfig>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final String tbcFile;
    private final String tcfFile;
    private final boolean forceReload;
    private final boolean loadOnly;
    private final boolean keepConfig;
    private final List<GlobalConstant> constants;

    @DataBoundConstructor
    public TestConfig(String tbcFile, String tcfFile, boolean forceReload, boolean loadOnly, boolean keepConfig, List<GlobalConstant> constants) {
        this.tbcFile = StringUtils.trimToEmpty((String)tbcFile);
        this.tcfFile = StringUtils.trimToEmpty((String)tcfFile);
        this.forceReload = forceReload;
        this.loadOnly = loadOnly;
        this.keepConfig = keepConfig;
        this.constants = constants == null ? new ArrayList() : TestConfig.removeEmptyConstants(constants);
    }

    public TestConfig(String tbcFile, String tcfFile) {
        this(tbcFile, tcfFile, false, false, false, null);
    }

    public TestConfig(String tbcFile, String tcfFile, boolean forceReload, boolean loadOnly) {
        this(tbcFile, tcfFile, forceReload, loadOnly, false, null);
    }

    private static List<GlobalConstant> removeEmptyConstants(List<GlobalConstant> constants) {
        ArrayList<GlobalConstant> validConstants = new ArrayList<GlobalConstant>();
        for (GlobalConstant constant : constants) {
            if (!StringUtils.isNotBlank((String)constant.getName())) continue;
            validConstants.add(constant);
        }
        return validConstants;
    }

    public static TestConfig newInstance() {
        return new TestConfig(null, null, false, false, false, null);
    }

    public String getTbcFile() {
        return this.tbcFile;
    }

    public String getTcfFile() {
        return this.tcfFile;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    public boolean isLoadOnly() {
        return this.loadOnly;
    }

    public boolean isKeepConfig() {
        return this.keepConfig;
    }

    public List<GlobalConstant> getConstants() {
        return this.constants;
    }

    @Override
    public TestConfig expand(EnvVars envVars) {
        String expTbcFile = envVars.expand(this.getTbcFile());
        String expTcfFile = envVars.expand(this.getTcfFile());
        ArrayList<GlobalConstant> constants = new ArrayList<GlobalConstant>();
        for (GlobalConstant constant : this.getConstants()) {
            constants.add(constant.expand(envVars));
        }
        return new TestConfig(expTbcFile, expTcfFile, this.isForceReload(), this.isLoadOnly(), this.isKeepConfig(), constants);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof TestConfig) {
            TestConfig that = (TestConfig)other;
            result = Objects.equals(this.tbcFile, that.tbcFile) && Objects.equals(this.tcfFile, that.tcfFile) && Objects.equals(this.constants, that.constants) && this.forceReload == that.forceReload && this.loadOnly == that.loadOnly && this.keepConfig == that.keepConfig;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.tbcFile).append((Object)this.tcfFile).append(this.forceReload).append(this.loadOnly).append(this.keepConfig).append(this.constants).toHashCode();
    }

    @Extension
    public static class DescriptorImpl<T>
    extends Descriptor<TestConfig> {
        private final TestValidator testValidator = new TestValidator();

        @Nonnull
        public String getDisplayName() {
            return "Test Configuration";
        }

        public FormValidation doCheckTbcFile(@QueryParameter String value) {
            return this.testValidator.validateTbcFile(value);
        }

        public FormValidation doCheckTcfFile(@QueryParameter String value) {
            return this.testValidator.validateTcfFile(value);
        }
    }
}

