/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PackageParameter
extends AbstractDescribableImpl<PackageParameter>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;

    @DataBoundConstructor
    public PackageParameter(String name, String value) {
        this.name = StringUtils.trimToEmpty((String)name);
        this.value = StringUtils.trimToEmpty((String)value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public PackageParameter expand(EnvVars envVars) {
        String expandedName = envVars.expand(this.getName());
        String expandedValue = envVars.expand(this.getValue());
        return new PackageParameter(expandedName, expandedValue);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof PackageParameter) {
            PackageParameter that = (PackageParameter)other;
            result = Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.value).toHashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PackageParameter> {
        private final TestValidator testValidator = new TestValidator();

        @Nonnull
        public String getDisplayName() {
            return "Package Parameter";
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.testValidator.validateParameterName(value);
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            return this.testValidator.validateParameterValue(value);
        }
    }
}

