/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PackageOutputParameter
extends AbstractDescribableImpl<PackageOutputParameter>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final String name;

    @DataBoundConstructor
    public PackageOutputParameter(String name) {
        this.name = StringUtils.trimToEmpty((String)name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public PackageOutputParameter expand(EnvVars envVars) {
        String expandedVariable = envVars.expand(this.getName());
        return new PackageOutputParameter(expandedVariable);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof PackageOutputParameter) {
            PackageOutputParameter that = (PackageOutputParameter)other;
            result = Objects.equals(this.name, that.name);
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).toHashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PackageOutputParameter> {
        private final TestValidator testValidator = new TestValidator();

        @Nonnull
        public String getDisplayName() {
            return "Package Output Parameter Name";
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.testValidator.validatePackageOutputParameterName(value);
        }
    }
}

