/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageOutputParameter;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageParameter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;

public class PackageConfig
extends AbstractDescribableImpl<PackageConfig>
implements Serializable,
ExpandableConfig {
    private static final long serialVersionUID = 1L;
    private final boolean runTest;
    private final boolean runTraceAnalysis;
    private final List<PackageParameter> parameters;
    private final List<PackageOutputParameter> outputParameters;

    @DataBoundConstructor
    public PackageConfig(boolean runTest, boolean runTraceAnalysis, List<PackageParameter> parameters, List<PackageOutputParameter> outputParameters) {
        this.runTest = runTest;
        this.runTraceAnalysis = runTraceAnalysis;
        this.parameters = parameters == null ? new ArrayList() : PackageConfig.removeEmptyParameters(parameters);
        this.outputParameters = outputParameters == null ? new ArrayList() : PackageConfig.removeEmptyOutputParameters(outputParameters);
    }

    public PackageConfig(boolean runTest, boolean runTraceAnalysis) {
        this.runTest = runTest;
        this.runTraceAnalysis = runTraceAnalysis;
        this.parameters = new ArrayList<PackageParameter>();
        this.outputParameters = new ArrayList<PackageOutputParameter>();
    }

    private static List<PackageParameter> removeEmptyParameters(List<PackageParameter> parameters) {
        ArrayList<PackageParameter> validParameters = new ArrayList<PackageParameter>();
        for (PackageParameter parameter : parameters) {
            if (!StringUtils.isNotBlank((String)parameter.getName())) continue;
            validParameters.add(parameter);
        }
        return validParameters;
    }

    private static List<PackageOutputParameter> removeEmptyOutputParameters(List<PackageOutputParameter> outputParameters) {
        ArrayList<PackageOutputParameter> validOutputParameters = new ArrayList<PackageOutputParameter>();
        for (PackageOutputParameter outputParameter : outputParameters) {
            if (!StringUtils.isNotBlank((String)outputParameter.getName())) continue;
            validOutputParameters.add(outputParameter);
        }
        return validOutputParameters;
    }

    public static PackageConfig newInstance() {
        return new PackageConfig(true, true, null, null);
    }

    public boolean isRunTest() {
        return this.runTest;
    }

    public boolean isRunTraceAnalysis() {
        return this.runTraceAnalysis;
    }

    public List<PackageParameter> getParameters() {
        return this.parameters;
    }

    public List<PackageOutputParameter> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public PackageConfig expand(EnvVars envVars) {
        ArrayList<PackageParameter> parameters = new ArrayList<PackageParameter>();
        for (PackageParameter param : this.getParameters()) {
            parameters.add(param.expand(envVars));
        }
        ArrayList<PackageOutputParameter> outputParameters = new ArrayList<PackageOutputParameter>();
        for (PackageOutputParameter outParam : this.getOutputParameters()) {
            outputParameters.add(outParam.expand(envVars));
        }
        return new PackageConfig(this.isRunTest(), this.isRunTraceAnalysis(), parameters, outputParameters);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof PackageConfig) {
            PackageConfig that = (PackageConfig)other;
            result = Objects.equals(this.parameters, that.parameters) && Objects.equals(this.outputParameters, that.outputParameters) && this.runTest == that.runTest && this.runTraceAnalysis == that.runTraceAnalysis;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.runTest).append(this.runTraceAnalysis).append(this.parameters).append(this.outputParameters).toHashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PackageConfig> {
        @Nonnull
        public String getDisplayName() {
            return "Package Configuration";
        }
    }
}

