/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportProjectConfig
extends ImportConfig {
    private static final long serialVersionUID = 1L;
    private final boolean importMissingPackages;

    @DataBoundConstructor
    public ImportProjectConfig(String tmsPath, String importPath, boolean importMissingPackages, String credentialsId, String timeout) {
        super(tmsPath, importPath, credentialsId, timeout);
        this.importMissingPackages = importMissingPackages;
    }

    public boolean isImportMissingPackages() {
        return this.importMissingPackages;
    }

    @Override
    public ImportProjectConfig expand(EnvVars envVars) {
        String expTmsPath = envVars.expand(this.getTmsPath());
        String expImportPath = envVars.expand(this.getImportPath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ImportProjectConfig(expTmsPath, expImportPath, this.isImportMissingPackages(), expCredentialsId, expTimeout);
    }

    @Override
    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ImportProjectConfig) {
            ImportProjectConfig that = (ImportProjectConfig)other;
            result = that.canEqual(this) && super.equals(that) && this.importMissingPackages == that.importMissingPackages;
        }
        return result;
    }

    @Override
    public final boolean canEqual(Object other) {
        return other instanceof ImportProjectConfig;
    }

    @Override
    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append(super.hashCode()).append(this.importMissingPackages).toHashCode();
    }

    @Extension(ordinal=3.0)
    public static class DescriptorImpl
    extends ImportConfig.DescriptorImpl {
        public static int getDefaultTimeout() {
            return 60;
        }

        @Override
        public FormValidation doCheckTmsPath(@QueryParameter String value) {
            return this.tmsValidator.validateTestPath(value);
        }

        @Override
        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return this.tmsValidator.validateTimeout(value, DescriptorImpl.getDefaultTimeout());
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ImportProjectConfig_DisplayName();
        }
    }
}

