/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportProjectAttributeConfig
extends ImportAttributeConfig {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ImportProjectAttributeConfig(String filePath, String credentialsId, String timeout) {
        super(filePath, credentialsId, timeout);
    }

    @Override
    public ImportProjectAttributeConfig expand(EnvVars envVars) {
        String expFilePath = envVars.expand(this.getFilePath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ImportProjectAttributeConfig(expFilePath, expCredentialsId, expTimeout);
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends ImportAttributeConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return this.tmsValidator.validateProjectFile(value);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ImportProjectAttributeConfig_DisplayName();
        }
    }
}

