/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportPackageConfig
extends ImportConfig {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ImportPackageConfig(String tmsPath, String importPath, String credentialsId, String timeout) {
        super(tmsPath, importPath, credentialsId, timeout);
    }

    @Override
    public ImportPackageConfig expand(EnvVars envVars) {
        String expTmsPath = envVars.expand(this.getTmsPath());
        String expImportPath = envVars.expand(this.getImportPath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ImportPackageConfig(expTmsPath, expImportPath, expCredentialsId, expTimeout);
    }

    @Override
    public final boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof ImportPackageConfig;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Extension(ordinal=3.0)
    public static class DescriptorImpl
    extends ImportConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckTmsPath(@QueryParameter String value) {
            return this.tmsValidator.validateTestPath(value);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ImportPackageConfig_DisplayName();
        }
    }
}

