/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ImportPackageAttributeConfig
extends ImportAttributeConfig {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ImportPackageAttributeConfig(String filePath, String credentialsId, String timeout) {
        super(filePath, credentialsId, timeout);
    }

    @Override
    public ImportPackageAttributeConfig expand(EnvVars envVars) {
        String expFilePath = envVars.expand(this.getFilePath());
        String expCredentialsId = envVars.expand(this.getCredentialsId());
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(60));
        return new ImportPackageAttributeConfig(expFilePath, expCredentialsId, expTimeout);
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends ImportAttributeConfig.DescriptorImpl {
        @Override
        public FormValidation doCheckFilePath(@QueryParameter String value) {
            return this.tmsValidator.validatePackageFile(value);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ImportPackageAttributeConfig_DisplayName();
        }
    }
}

