/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import hudson.util.FormValidation;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.QueryParameter;

public abstract class ImportConfig
extends TMSConfig {
    private static final long serialVersionUID = 1L;
    private final String tmsPath;
    private final String importPath;

    public ImportConfig(String tmsPath, String importPath, String credentialsId, String timeout) {
        super(credentialsId, timeout);
        this.tmsPath = StringUtils.trimToEmpty((String)tmsPath);
        this.importPath = StringUtils.trimToEmpty((String)importPath);
    }

    public String getTmsPath() {
        return this.tmsPath;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (this.canEqual(other) && other instanceof ImportConfig) {
            ImportConfig that = (ImportConfig)other;
            String tmsPath = this.getTmsPath();
            String importPath = this.getImportPath();
            String thatFilePath = that.getTmsPath();
            String thatImportPath = that.getImportPath();
            result = that.canEqual(this) && Objects.equals(tmsPath, thatFilePath) && Objects.equals(importPath, thatImportPath) && (this.getCredentialsId() == null ? that.getCredentialsId() == null : this.getCredentialsId().equals(that.getCredentialsId())) && (this.getTimeout() == null ? that.getTimeout() == null : this.getTimeout().equals(that.getTimeout()));
        }
        return result;
    }

    public boolean canEqual(Object other) {
        return other instanceof ImportConfig;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.getTmsPath()).append((Object)this.getImportPath()).append((Object)this.getCredentialsId()).append((Object)this.getTimeout()).toHashCode();
    }

    public static abstract class DescriptorImpl
    extends TMSConfig.DescriptorImpl {
        public abstract FormValidation doCheckTmsPath(@QueryParameter String var1);

        public FormValidation doCheckImportPath(@QueryParameter String value) {
            return this.tmsValidator.validateImportPath(value);
        }
    }
}

