/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.config;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ExecutionConfig
extends AbstractDescribableImpl<ExecutionConfig>
implements Serializable,
ExpandableConfig {
    protected static final int DEFAULT_TIMEOUT = 3600;
    private static final long serialVersionUID = 1L;
    private final String timeout;
    private final boolean stopOnError;
    private final boolean checkTestFile;
    private final boolean recordWarnings;

    @DataBoundConstructor
    public ExecutionConfig(String timeout, boolean stopOnError, boolean checkTestFile, boolean recordWarnings) {
        this.timeout = StringUtils.defaultIfBlank((String)timeout, (String)String.valueOf(3600));
        this.stopOnError = stopOnError;
        this.checkTestFile = checkTestFile;
        this.recordWarnings = recordWarnings;
    }

    public ExecutionConfig(int timeout, boolean stopOnError, boolean checkTestFile, boolean recordWarnings) {
        this(String.valueOf(timeout), stopOnError, checkTestFile, recordWarnings);
    }

    public static int parse(String param) {
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            return 3600;
        }
    }

    public static int getDefaultTimeout() {
        return 3600;
    }

    public static ExecutionConfig newInstance() {
        return new ExecutionConfig(null, true, true, false);
    }

    public int getParsedTimeout() {
        return ExecutionConfig.parse(this.getTimeout());
    }

    public String getTimeout() {
        return this.timeout;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public boolean isCheckTestFile() {
        return this.checkTestFile;
    }

    public boolean isRecordWarnings() {
        return this.recordWarnings;
    }

    @Override
    public ExecutionConfig expand(EnvVars envVars) {
        String expTimeout = EnvUtil.expandEnvVar(this.getTimeout(), envVars, String.valueOf(3600));
        return new ExecutionConfig(expTimeout, this.isStopOnError(), this.isCheckTestFile(), this.recordWarnings);
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ExecutionConfig) {
            ExecutionConfig that = (ExecutionConfig)other;
            result = Objects.equals(this.timeout, that.timeout) && this.stopOnError == that.stopOnError && this.checkTestFile == that.checkTestFile && this.recordWarnings == that.recordWarnings;
        }
        return result;
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.timeout).append(this.stopOnError).append(this.checkTestFile).append(this.recordWarnings).toHashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecutionConfig> {
        private final TestValidator testValidator = new TestValidator();

        public static int getDefaultTimeout() {
            return 3600;
        }

        @Nonnull
        public String getDisplayName() {
            return "Execution Configuration";
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return this.testValidator.validateTimeout(value, DescriptorImpl.getDefaultTimeout());
        }
    }
}

